/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.social.openshift;

import org.junit.Assert;
import org.junit.Test;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.social.openshift.OpenshiftV3IdentityProvider;
import org.keycloak.social.openshift.OpenshiftV3IdentityProviderConfig;

public class OpenshiftV3IdentityProviderTest {
    @Test
    public void shouldConstructProviderUrls() {
        OpenshiftV3IdentityProviderConfig config = new OpenshiftV3IdentityProviderConfig(new IdentityProviderModel());
        config.setBaseUrl("http://openshift.io:8443");
        OpenshiftV3IdentityProvider openshiftV3IdentityProvider = new OpenshiftV3IdentityProvider(null, config);
        this.assertConfiguredUrls(openshiftV3IdentityProvider);
    }

    @Test
    public void shouldConstructProviderUrlsForBaseUrlWithTrailingSlash() {
        OpenshiftV3IdentityProviderConfig config = new OpenshiftV3IdentityProviderConfig(new IdentityProviderModel());
        config.setBaseUrl("http://openshift.io:8443/");
        OpenshiftV3IdentityProvider openshiftV3IdentityProvider = new OpenshiftV3IdentityProvider(null, config);
        this.assertConfiguredUrls(openshiftV3IdentityProvider);
    }

    private void assertConfiguredUrls(OpenshiftV3IdentityProvider openshiftV3IdentityProvider) {
        Assert.assertEquals((Object)"http://openshift.io:8443/oauth/authorize", (Object)((OpenshiftV3IdentityProviderConfig)openshiftV3IdentityProvider.getConfig()).getAuthorizationUrl());
        Assert.assertEquals((Object)"http://openshift.io:8443/oauth/token", (Object)((OpenshiftV3IdentityProviderConfig)openshiftV3IdentityProvider.getConfig()).getTokenUrl());
        Assert.assertEquals((Object)"http://openshift.io:8443/oapi/v1/users/~", (Object)((OpenshiftV3IdentityProviderConfig)openshiftV3IdentityProvider.getConfig()).getUserInfoUrl());
    }
}

