/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.theme.KeycloakSanitizerMethod;

public class KeycloakSanitizerTest {
    private final KeycloakSanitizerMethod kcEscape = new KeycloakSanitizerMethod();

    @Test
    public void testEscapes() throws Exception {
        ArrayList<String> html = new ArrayList<String>();
        html.add("<div class=\"kc-logo-text\"><script>alert('foo');</script><span>Keycloak</span></div>");
        String expectedResult = "<div class=\"kc-logo-text\"><span>Keycloak</span></div>";
        this.assertResult(expectedResult, html);
        html.set(0, "<h1>Foo</h1>");
        expectedResult = "<h1>Foo</h1>";
        this.assertResult(expectedResult, html);
        html.set(0, "<div class=\"kc-logo-text\"><span>Keycloak</span></div><svg onload=alert(document.cookie);>");
        expectedResult = "<div class=\"kc-logo-text\"><span>Keycloak</span></div>";
        this.assertResult(expectedResult, html);
        html.set(0, null);
        expectedResult = null;
        try {
            this.assertResult(expectedResult, html);
            Assert.fail((String)"Expected NPE");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        html.set(0, "");
        expectedResult = "";
        this.assertResult(expectedResult, html);
    }

    @Test
    public void testUrls() throws Exception {
        ArrayList<String> html = new ArrayList<String>();
        html.add("<p><a href='https://localhost'>link</a></p>");
        this.assertResult("<p><a href=\"https://localhost\" rel=\"nofollow\">link</a></p>", html);
        html.set(0, "<p><a href=\"\">link</a></p>");
        this.assertResult("<p>link</p>", html);
        html.set(0, "<p><a href=\"javascript:alert('hello!');\">link</a></p>");
        this.assertResult("<p>link</p>", html);
        html.set(0, "<p><a href=\"javascript:alert(document.domain);\">link</a></p>");
        this.assertResult("<p>link</p>", html);
        html.set(0, "<p><a href=\"javascript&colon;alert(document.domain);\">link</a></p>");
        this.assertResult("<p>link</p>", html);
        html.set(0, "<p><a href=\"javascript&\u0000colon;alert(document.domain);\">link</a></p>");
        this.assertResult("<p>link</p>", html);
        html.set(0, "<p><a href=\"javascript&amp;amp;\u0000colon;alert(document.domain);\">link</a></p>");
        this.assertResult("<p>link</p>", html);
        html.set(0, "<p><a href=\"javascript&amp;amp;amp;amp;amp;amp;amp;amp;amp;amp;amp;\u0000colon;alert(document.domain);\">link</a></p>");
        this.assertResult("", html);
        html.set(0, "<p><a href=\"https://localhost?key=123&msg=abc\">link</a></p>");
        this.assertResult("<p><a href=\"https://localhost?key=123&msg=abc\" rel=\"nofollow\">link</a></p>", html);
        html.set(0, "<p><a href='https://localhost?key=123&msg=abc'>link1</a><a href=\"https://localhost?key=abc&msg=123\">link2</a></p>");
        this.assertResult("<p><a href=\"https://localhost?key=123&msg=abc\" rel=\"nofollow\">link1</a><a href=\"https://localhost?key=abc&msg=123\" rel=\"nofollow\">link2</a></p>", html);
    }

    private void assertResult(String expectedResult, List<String> html) throws Exception {
        String result = this.kcEscape.exec(html).toString();
        Assert.assertEquals((Object)expectedResult, (Object)result);
    }
}

