/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.theme.ResourceLoader;

public class ResourceLoaderTest {
    static String NONE = "../";
    static String SINGLE = "%2E%2E%2F";
    static String DOUBLE = "%252E%252E%252F";

    @Test
    public void testResource() throws IOException {
        String parent = "dummy-resources/parent";
        this.assertResourceAsStream(parent, "myresource.css", true, true);
        this.assertResourceAsStream(parent, NONE + "myresource.css", false, true);
        this.assertResourceAsStream(parent, SINGLE + "myresource.css", false, false);
        this.assertResourceAsStream(parent, DOUBLE + "myresource.css", false, false);
        this.assertResourceAsStream(parent, "one/" + NONE + "myresource.css", true, true);
        this.assertResourceAsStream(parent, "one/" + SINGLE + "myresource.css", false, false);
        this.assertResourceAsStream(parent, "one/" + DOUBLE + "myresource.css", false, false);
        this.assertResourceAsStream(parent, "one/two/" + NONE + NONE + "myresource.css", true, true);
        this.assertResourceAsStream(parent, "one/" + NONE + NONE + "myresource.css", false, true);
    }

    @Test
    public void testFiles() throws IOException {
        Path tempDirectory = Files.createTempDirectory("safepath-test", new FileAttribute[0]);
        File parent = new File(tempDirectory.toFile(), "resources");
        Assert.assertTrue((boolean)parent.mkdir());
        new FileOutputStream(new File(tempDirectory.toFile(), "myresource.css")).close();
        new FileOutputStream(new File(parent, "myresource.css")).close();
        this.assertFileAsStream(parent, "myresource.css", true, true);
        this.assertFileAsStream(parent, NONE + "myresource.css", false, true);
        this.assertFileAsStream(parent, SINGLE + "myresource.css", false, false);
        this.assertFileAsStream(parent, DOUBLE + "myresource.css", false, false);
        this.assertFileAsStream(new File(tempDirectory.toFile(), "test/../resources/"), "myresource.css", true, true);
        Path relativeParent = Paths.get(".", new String[0]).toAbsolutePath().relativize(parent.toPath());
        this.assertFileAsStream(relativeParent.toFile(), "myresource.css", true, true);
    }

    private void assertResourceAsStream(String parent, String resource, boolean expectValid, boolean expectResourceToExist) throws IOException {
        InputStream verified = ResourceLoader.getResourceAsStream((String)parent, (String)resource);
        if (expectValid) {
            Assert.assertNotNull((Object)verified);
        } else {
            Assert.assertNull((Object)verified);
        }
        if (expectResourceToExist) {
            Assert.assertNotNull((Object)ResourceLoader.class.getClassLoader().getResource(parent + "/" + resource));
        }
    }

    private void assertFileAsStream(File parent, String resource, boolean expectValid, boolean expectFileToExist) throws IOException {
        InputStream verified = ResourceLoader.getFileAsStream((File)parent, (String)resource);
        if (expectValid) {
            Assert.assertNotNull((Object)verified);
        } else {
            Assert.assertNull((Object)verified);
        }
        if (expectFileToExist) {
            Assert.assertTrue((boolean)new File(parent, resource).getCanonicalFile().isFile());
        }
    }
}

