/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme.beans;

import freemarker.template.TemplateModelException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.keycloak.theme.beans.LinkExpirationFormatterMethod;

public class LinkExpirationFormatterMethodTest {
    protected static final Locale locale = Locale.ENGLISH;
    protected static final Properties messages = new Properties();

    protected List<Object> toList(Object ... objects) {
        return Arrays.asList(objects);
    }

    @Test
    public void inputtypes_null() throws TemplateModelException {
        LinkExpirationFormatterMethod tested = new LinkExpirationFormatterMethod(messages, locale);
        Assert.assertEquals((Object)"", (Object)tested.exec(Collections.emptyList()));
    }

    @Test
    public void inputtypes_string_empty() throws TemplateModelException {
        LinkExpirationFormatterMethod tested = new LinkExpirationFormatterMethod(messages, locale);
        Assert.assertEquals((Object)"", (Object)tested.exec(this.toList("")));
        Assert.assertEquals((Object)" ", (Object)tested.exec(this.toList(" ")));
    }

    @Test
    public void inputtypes_string_number() throws TemplateModelException {
        LinkExpirationFormatterMethod tested = new LinkExpirationFormatterMethod(messages, locale);
        Assert.assertEquals((Object)"2 minutes", (Object)tested.exec(this.toList("2")));
        Assert.assertEquals((Object)"2 minutes", (Object)tested.exec(this.toList(" 2 ")));
    }

    @Test
    public void inputtypes_string_notanumber() throws TemplateModelException {
        LinkExpirationFormatterMethod tested = new LinkExpirationFormatterMethod(messages, locale);
        Assert.assertEquals((Object)"ahoj", (Object)tested.exec(this.toList("ahoj")));
    }

    @Test
    public void inputtypes_number() throws TemplateModelException {
        LinkExpirationFormatterMethod tested = new LinkExpirationFormatterMethod(messages, locale);
        Assert.assertEquals((Object)"5 minutes", (Object)tested.exec(this.toList(5)));
        Assert.assertEquals((Object)"5 minutes", (Object)tested.exec(this.toList(5L)));
    }

    @Test
    public void format_second_zero() throws TemplateModelException {
        LinkExpirationFormatterMethod tested = new LinkExpirationFormatterMethod(messages, locale);
        Assert.assertEquals((Object)"0 seconds", (Object)tested.exec(this.toList(0)));
    }

    @Test
    public void format_minute_one() throws TemplateModelException {
        LinkExpirationFormatterMethod tested = new LinkExpirationFormatterMethod(messages, locale);
        Assert.assertEquals((Object)"1 minute", (Object)tested.exec(this.toList(1)));
    }

    @Test
    public void format_minute_more() throws TemplateModelException {
        LinkExpirationFormatterMethod tested = new LinkExpirationFormatterMethod(messages, locale);
        Assert.assertEquals((Object)"2 minutes", (Object)tested.exec(this.toList(2)));
        Assert.assertEquals((Object)"3 minutes-3", (Object)tested.exec(this.toList(3)));
        Assert.assertEquals((Object)"5 minutes", (Object)tested.exec(this.toList(5)));
        Assert.assertEquals((Object)"24 minutes", (Object)tested.exec(this.toList(24)));
        Assert.assertEquals((Object)"59 minutes", (Object)tested.exec(this.toList(59)));
        Assert.assertEquals((Object)"61 minutes", (Object)tested.exec(this.toList(61)));
    }

    @Test
    public void format_hour_one() throws TemplateModelException {
        LinkExpirationFormatterMethod tested = new LinkExpirationFormatterMethod(messages, locale);
        Assert.assertEquals((Object)"1 hour", (Object)tested.exec(this.toList(60)));
    }

    @Test
    public void format_hour_more() throws TemplateModelException {
        LinkExpirationFormatterMethod tested = new LinkExpirationFormatterMethod(messages, locale);
        Assert.assertEquals((Object)"2 hours", (Object)tested.exec(this.toList(120)));
        Assert.assertEquals((Object)"5 hours", (Object)tested.exec(this.toList(300)));
        Assert.assertEquals((Object)"23 hours", (Object)tested.exec(this.toList(1380)));
        Assert.assertEquals((Object)"25 hours", (Object)tested.exec(this.toList(1500)));
    }

    @Test
    public void format_day_one() throws TemplateModelException {
        LinkExpirationFormatterMethod tested = new LinkExpirationFormatterMethod(messages, locale);
        Assert.assertEquals((Object)"1 day", (Object)tested.exec(this.toList(1440)));
    }

    @Test
    public void format_day_more() throws TemplateModelException {
        LinkExpirationFormatterMethod tested = new LinkExpirationFormatterMethod(messages, locale);
        Assert.assertEquals((Object)"2 days", (Object)tested.exec(this.toList(2880)));
        Assert.assertEquals((Object)"5 days", (Object)tested.exec(this.toList(7200)));
    }

    @Test
    public void format_simple_no_choice() throws TemplateModelException {
        Properties simpleMessages = new Properties();
        simpleMessages.put("linkExpirationFormatter.timePeriodUnit.seconds", "seconds-simple");
        simpleMessages.put("linkExpirationFormatter.timePeriodUnit.minutes", "minutes-simple");
        simpleMessages.put("linkExpirationFormatter.timePeriodUnit.hours", "hours-simple");
        simpleMessages.put("linkExpirationFormatter.timePeriodUnit.days", "days-simple");
        LinkExpirationFormatterMethod tested = new LinkExpirationFormatterMethod(simpleMessages, locale);
        Assert.assertEquals((Object)"2 days-simple", (Object)tested.exec(this.toList(2880)));
        Assert.assertEquals((Object)"5 days-simple", (Object)tested.exec(this.toList(7200)));
    }

    @Ignore
    @Test
    public void convert() throws IOException {
        String[] units = new String[]{"seconds", "minutes", "hours", "days"};
        for (Path path : Files.list(Paths.get("../themes/src/main/resources-community/theme/base/email/messages", new String[0])).collect(Collectors.toList())) {
            Properties p = new Properties();
            p.load(Files.newBufferedReader(path, StandardCharsets.UTF_8));
            FileWriter fw = new FileWriter(path.toFile(), true);
            boolean firstEntry = true;
            for (String unit : units) {
                StringBuilder choicePattern = new StringBuilder();
                String base = "linkExpirationFormatter.timePeriodUnit." + unit;
                String defaultValue = p.getProperty(base);
                if (defaultValue == null) continue;
                choicePattern.append("{0,choice,0#").append(defaultValue).append("|");
                int last = 0;
                int entry = 0;
                String previous = defaultValue;
                for (int i = 0; i < 10; ++i) {
                    String value = p.getProperty(base + "." + i);
                    if (value == null) continue;
                    last = i;
                    if (Objects.equals(value, previous)) continue;
                    entry = i;
                    previous = value;
                    choicePattern.append(i).append("#").append(value).append("|");
                }
                choicePattern.append(last).append("<").append(defaultValue).append("}");
                if (entry == 0) {
                    choicePattern.setLength(0);
                    choicePattern.append(defaultValue);
                }
                choicePattern.insert(0, base + "=");
                choicePattern.append("\n");
                if (firstEntry) {
                    fw.write("\n");
                    firstEntry = false;
                }
                fw.write(choicePattern.toString());
            }
            fw.close();
        }
    }

    static {
        messages.put("linkExpirationFormatter.timePeriodUnit.seconds", "{0,choice,0#seconds|1#second|1<seconds}");
        messages.put("linkExpirationFormatter.timePeriodUnit.minutes", "{0,choice,0#minutes|1#minute|2#minutes|3#minutes-3|3<minutes}");
        messages.put("linkExpirationFormatter.timePeriodUnit.hours", "{0,choice,0#hours|1#hour|1<hours}");
        messages.put("linkExpirationFormatter.timePeriodUnit.days", "{0,choice,0#days|1#day|1<days}");
    }
}

