/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.truststore;

import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.Config;
import org.keycloak.common.enums.HostnameVerificationPolicy;
import org.keycloak.truststore.FileTruststoreProviderFactory;
import org.keycloak.truststore.TruststoreProvider;
import org.keycloak.utils.ScopeUtil;

public class FileTruststoreProviderFactoryTest {
    @Test
    public void testFallbackToSystemTruststore() throws IOException {
        FileTruststoreProviderFactory factory = new FileTruststoreProviderFactory();
        factory.init((Config.Scope)ScopeUtil.createScope(new HashMap<String, String>()));
        TruststoreProvider provider = factory.create(null);
        Assert.assertNotNull((Object)provider.getTruststore());
        Assert.assertEquals((Object)HostnameVerificationPolicy.DEFAULT, (Object)provider.getPolicy());
    }

    @Test
    public void testFallbackToSystemTruststoreWithHostnameVerification() throws IOException {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("hostname-verification-policy", HostnameVerificationPolicy.ANY.name());
        FileTruststoreProviderFactory factory = new FileTruststoreProviderFactory();
        factory.init((Config.Scope)ScopeUtil.createScope(values));
        TruststoreProvider provider = factory.create(null);
        Assert.assertNotNull((Object)provider.getTruststore());
        Assert.assertEquals((Object)HostnameVerificationPolicy.ANY, (Object)provider.getPolicy());
    }
}

