/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.credential;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.CredentialProviderFactory;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserCredentialManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.OnUserCache;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageManager;
import org.keycloak.storage.UserStorageProvider;

public class UserCredentialStoreManager
implements UserCredentialManager,
OnUserCache {
    protected KeycloakSession session;

    public UserCredentialStoreManager(KeycloakSession session) {
        this.session = session;
    }

    protected UserCredentialStore getStoreForUser(UserModel user) {
        if (StorageId.isLocalStorage((UserModel)user)) {
            return (UserCredentialStore)this.session.userLocalStorage();
        }
        return (UserCredentialStore)this.session.userFederatedStorage();
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        this.getStoreForUser(user).updateCredential(realm, user, cred);
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        return this.getStoreForUser(user).createCredential(realm, user, cred);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        return this.getStoreForUser(user).removeStoredCredential(realm, user, id);
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        return this.getStoreForUser(user).getStoredCredentialById(realm, user, id);
    }

    public List<CredentialModel> getStoredCredentials(RealmModel realm, UserModel user) {
        return this.getStoreForUser(user).getStoredCredentials(realm, user);
    }

    public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, UserModel user, String type) {
        return this.getStoreForUser(user).getStoredCredentialsByType(realm, user, type);
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        return this.getStoreForUser(user).getStoredCredentialByNameAndType(realm, user, name, type);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput ... inputs) {
        return this.isValid(realm, user, Arrays.asList(inputs));
    }

    public boolean isValid(RealmModel realm, UserModel user, List<CredentialInput> inputs) {
        UserStorageProvider provider;
        LinkedList<CredentialInput> toValidate = new LinkedList<CredentialInput>();
        toValidate.addAll(inputs);
        if (!StorageId.isLocalStorage((UserModel)user)) {
            String providerId = StorageId.resolveProviderId((UserModel)user);
            UserStorageProvider provider2 = UserStorageManager.getStorageProvider(this.session, realm, providerId);
            if (provider2 instanceof CredentialInputValidator) {
                Iterator it = toValidate.iterator();
                while (it.hasNext()) {
                    CredentialInputValidator validator = (CredentialInputValidator)provider2;
                    CredentialInput input = (CredentialInput)it.next();
                    if (!validator.supportsCredentialType(input.getType()) || !validator.isValid(realm, user, input)) continue;
                    it.remove();
                }
            }
        } else if (user.getFederationLink() != null && (provider = UserStorageManager.getStorageProvider(this.session, realm, user.getFederationLink())) != null && provider instanceof CredentialInputValidator) {
            this.validate(realm, user, toValidate, (CredentialInputValidator)provider);
        }
        if (toValidate.isEmpty()) {
            return true;
        }
        List<CredentialInputValidator> credentialProviders = UserCredentialStoreManager.getCredentialProviders(this.session, realm, CredentialInputValidator.class);
        for (CredentialInputValidator validator : credentialProviders) {
            this.validate(realm, user, toValidate, validator);
        }
        return toValidate.isEmpty();
    }

    private void validate(RealmModel realm, UserModel user, List<CredentialInput> toValidate, CredentialInputValidator validator) {
        Iterator<CredentialInput> it = toValidate.iterator();
        while (it.hasNext()) {
            CredentialInput input = it.next();
            if (!validator.supportsCredentialType(input.getType()) || !validator.isValid(realm, user, input)) continue;
            it.remove();
        }
    }

    public static <T> List<T> getCredentialProviders(KeycloakSession session, RealmModel realm, Class<T> type) {
        LinkedList<Provider> list = new LinkedList<Provider>();
        for (ProviderFactory f : session.getKeycloakSessionFactory().getProviderFactories(CredentialProvider.class)) {
            if (!Types.supports(type, (Object)f, CredentialProviderFactory.class)) continue;
            list.add(session.getProvider(CredentialProvider.class, f.getId()));
        }
        return list;
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        UserStorageProvider provider;
        CredentialInputUpdater updater2;
        String providerId;
        UserStorageProvider provider2;
        if (!StorageId.isLocalStorage((UserModel)user) ? (provider2 = UserStorageManager.getStorageProvider(this.session, realm, providerId = StorageId.resolveProviderId((UserModel)user))) instanceof CredentialInputUpdater && (updater2 = (CredentialInputUpdater)provider2).supportsCredentialType(input.getType()) && updater2.updateCredential(realm, user, input) : user.getFederationLink() != null && (provider = UserStorageManager.getStorageProvider(this.session, realm, user.getFederationLink())) != null && provider instanceof CredentialInputUpdater && ((CredentialInputUpdater)provider).updateCredential(realm, user, input)) {
            return;
        }
        List<CredentialInputUpdater> credentialProviders = UserCredentialStoreManager.getCredentialProviders(this.session, realm, CredentialInputUpdater.class);
        for (CredentialInputUpdater updater2 : credentialProviders) {
            if (!updater2.supportsCredentialType(input.getType()) || !updater2.updateCredential(realm, user, input)) continue;
            return;
        }
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
        UserStorageProvider provider;
        if (!StorageId.isLocalStorage((UserModel)user)) {
            CredentialInputUpdater updater;
            String providerId = StorageId.resolveProviderId((UserModel)user);
            UserStorageProvider provider2 = UserStorageManager.getStorageProvider(this.session, realm, providerId);
            if (provider2 instanceof CredentialInputUpdater && (updater = (CredentialInputUpdater)provider2).supportsCredentialType(credentialType)) {
                updater.disableCredentialType(realm, user, credentialType);
            }
        } else if (user.getFederationLink() != null && (provider = UserStorageManager.getStorageProvider(this.session, realm, user.getFederationLink())) != null && provider instanceof CredentialInputUpdater) {
            ((CredentialInputUpdater)provider).disableCredentialType(realm, user, credentialType);
        }
        List<CredentialInputUpdater> credentialProviders = UserCredentialStoreManager.getCredentialProviders(this.session, realm, CredentialInputUpdater.class);
        for (CredentialInputUpdater updater : credentialProviders) {
            if (!updater.supportsCredentialType(credentialType)) continue;
            updater.disableCredentialType(realm, user, credentialType);
        }
    }

    public Set<String> getDisableableCredentialTypes(RealmModel realm, UserModel user) {
        UserStorageProvider provider;
        HashSet<String> types = new HashSet<String>();
        if (!StorageId.isLocalStorage((UserModel)user)) {
            String providerId = StorageId.resolveProviderId((UserModel)user);
            UserStorageProvider provider2 = UserStorageManager.getStorageProvider(this.session, realm, providerId);
            if (provider2 instanceof CredentialInputUpdater) {
                CredentialInputUpdater updater = (CredentialInputUpdater)provider2;
                types.addAll(updater.getDisableableCredentialTypes(realm, user));
            }
        } else if (user.getFederationLink() != null && (provider = UserStorageManager.getStorageProvider(this.session, realm, user.getFederationLink())) != null && provider instanceof CredentialInputUpdater) {
            types.addAll(((CredentialInputUpdater)provider).getDisableableCredentialTypes(realm, user));
        }
        List<CredentialInputUpdater> credentialProviders = UserCredentialStoreManager.getCredentialProviders(this.session, realm, CredentialInputUpdater.class);
        for (CredentialInputUpdater updater : credentialProviders) {
            types.addAll(updater.getDisableableCredentialTypes(realm, user));
        }
        return types;
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String type) {
        UserStorageProvider provider;
        CredentialInputValidator validator;
        String providerId;
        UserStorageProvider provider2;
        if (!StorageId.isLocalStorage((UserModel)user) ? (provider2 = UserStorageManager.getStorageProvider(this.session, realm, providerId = StorageId.resolveProviderId((UserModel)user))) instanceof CredentialInputValidator && (validator = (CredentialInputValidator)provider2).supportsCredentialType(type) && validator.isConfiguredFor(realm, user, type) : user.getFederationLink() != null && (provider = UserStorageManager.getStorageProvider(this.session, realm, user.getFederationLink())) != null && provider instanceof CredentialInputValidator && ((CredentialInputValidator)provider).isConfiguredFor(realm, user, type)) {
            return true;
        }
        return this.isConfiguredLocally(realm, user, type);
    }

    public boolean isConfiguredLocally(RealmModel realm, UserModel user, String type) {
        List<CredentialInputValidator> credentialProviders = UserCredentialStoreManager.getCredentialProviders(this.session, realm, CredentialInputValidator.class);
        for (CredentialInputValidator validator : credentialProviders) {
            if (!validator.supportsCredentialType(type) || !validator.isConfiguredFor(realm, user, type)) continue;
            return true;
        }
        return false;
    }

    public CredentialValidationOutput authenticate(KeycloakSession session, RealmModel realm, CredentialInput input) {
        CredentialValidationOutput output;
        List<CredentialAuthentication> list = UserStorageManager.getStorageProviders(session, realm, CredentialAuthentication.class);
        for (CredentialAuthentication auth : list) {
            if (!auth.supportsCredentialAuthenticationFor(input.getType()) || (output = auth.authenticate(realm, input)) == null) continue;
            return output;
        }
        list = UserCredentialStoreManager.getCredentialProviders(session, realm, CredentialAuthentication.class);
        for (CredentialAuthentication auth : list) {
            if (!auth.supportsCredentialAuthenticationFor(input.getType()) || (output = auth.authenticate(realm, input)) == null) continue;
            return output;
        }
        return null;
    }

    public void onCache(RealmModel realm, CachedUserModel user, UserModel delegate) {
        List<OnUserCache> credentialProviders = UserCredentialStoreManager.getCredentialProviders(this.session, realm, OnUserCache.class);
        for (OnUserCache validator : credentialProviders) {
            validator.onCache(realm, user, delegate);
        }
    }

    public void close() {
    }
}

