/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.authentication.AuthenticationProcessor;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.AuthenticationFlowModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.services.managers.AuthenticationManager;

public abstract class AuthorizationEndpointBase {
    protected RealmModel realm;
    protected EventBuilder event;
    protected AuthenticationManager authManager;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected HttpRequest request;
    @Context
    protected KeycloakSession session;
    @Context
    protected ClientConnection clientConnection;

    public AuthorizationEndpointBase(RealmModel realm, EventBuilder event) {
        this.realm = realm;
        this.event = event;
    }

    protected AuthenticationProcessor createProcessor(ClientSessionModel clientSession, String flowId, String flowPath) {
        AuthenticationProcessor processor = new AuthenticationProcessor();
        processor.setClientSession(clientSession).setFlowPath(flowPath).setFlowId(flowId).setBrowserFlow(true).setConnection(this.clientConnection).setEventBuilder(this.event).setRealm(this.realm).setSession(this.session).setUriInfo(this.uriInfo).setRequest(this.request);
        return processor;
    }

    protected Response handleBrowserAuthenticationRequest(ClientSessionModel clientSession, LoginProtocol protocol, boolean isPassive, boolean redirectToAuthentication) {
        AuthenticationFlowModel flow = this.getAuthenticationFlow();
        String flowId = flow.getId();
        AuthenticationProcessor processor = this.createProcessor(clientSession, flowId, "authenticate");
        this.event.detail("code_id", clientSession.getId());
        if (isPassive) {
            try {
                if (processor.authenticateOnly() != null) {
                    Response response = protocol.sendError(clientSession, LoginProtocol.Error.PASSIVE_LOGIN_REQUIRED);
                    this.session.sessions().removeClientSession(this.realm, clientSession);
                    return response;
                }
                processor.attachSession();
                if (processor.isActionRequired()) {
                    Response response = protocol.sendError(clientSession, LoginProtocol.Error.PASSIVE_INTERACTION_REQUIRED);
                    this.session.sessions().removeClientSession(this.realm, clientSession);
                    return response;
                }
            }
            catch (Exception e) {
                return processor.handleBrowserException(e);
            }
            return processor.finishAuthentication(protocol);
        }
        try {
            RestartLoginCookie.setRestartCookie(this.session, this.realm, this.clientConnection, this.uriInfo, clientSession);
            if (redirectToAuthentication) {
                return processor.redirectToFlow();
            }
            return processor.authenticate();
        }
        catch (Exception e) {
            return processor.handleBrowserException(e);
        }
    }

    protected AuthenticationFlowModel getAuthenticationFlow() {
        return this.realm.getBrowserFlow();
    }
}

