/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions;

import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.authentication.RequiredActionContext;
import org.keycloak.authentication.RequiredActionFactory;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.common.util.Time;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.CredentialProvider;
import org.keycloak.credential.PasswordCredentialProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.ModelException;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.validation.Validation;

public class UpdatePassword
implements RequiredActionProvider,
RequiredActionFactory {
    private static final Logger logger = Logger.getLogger(UpdatePassword.class);

    public void evaluateTriggers(RequiredActionContext context) {
        PasswordCredentialProvider passwordProvider;
        CredentialModel password;
        int daysToExpirePassword = context.getRealm().getPasswordPolicy().getDaysToExpirePassword();
        if (daysToExpirePassword != -1 && (password = (passwordProvider = (PasswordCredentialProvider)context.getSession().getProvider(CredentialProvider.class, "keycloak-password")).getPassword(context.getRealm(), context.getUser())) != null) {
            if (password.getCreatedDate() == null) {
                context.getUser().addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                logger.debug((Object)"User is required to update password");
            } else {
                long timeToExpire;
                long timeElapsed = Time.toMillis((int)Time.currentTime()) - password.getCreatedDate();
                if (timeElapsed > (timeToExpire = TimeUnit.DAYS.toMillis(daysToExpirePassword))) {
                    context.getUser().addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                    logger.debug((Object)"User is required to update password");
                }
            }
        }
    }

    public void requiredActionChallenge(RequiredActionContext context) {
        Response challenge = context.form().setAttribute("username", (Object)context.getAuthenticationSession().getAuthenticatedUser().getUsername()).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
        context.challenge(challenge);
    }

    public void processAction(RequiredActionContext context) {
        EventBuilder event = context.getEvent();
        MultivaluedMap formData = context.getHttpRequest().getDecodedFormParameters();
        event.event(EventType.UPDATE_PASSWORD);
        String passwordNew = (String)formData.getFirst((Object)"password-new");
        String passwordConfirm = (String)formData.getFirst((Object)"password-confirm");
        EventBuilder errorEvent = event.clone().event(EventType.UPDATE_PASSWORD_ERROR).client(context.getAuthenticationSession().getClient()).user(context.getAuthenticationSession().getAuthenticatedUser());
        if (Validation.isBlank(passwordNew)) {
            Response challenge = context.form().setAttribute("username", (Object)context.getAuthenticationSession().getAuthenticatedUser().getUsername()).setError("missingPasswordMessage", new Object[0]).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            context.challenge(challenge);
            errorEvent.error("password_missing");
            return;
        }
        if (!passwordNew.equals(passwordConfirm)) {
            Response challenge = context.form().setAttribute("username", (Object)context.getAuthenticationSession().getAuthenticatedUser().getUsername()).setError("notMatchPasswordMessage", new Object[0]).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            context.challenge(challenge);
            errorEvent.error("password_confirm_error");
            return;
        }
        try {
            context.getSession().userCredentialManager().updateCredential(context.getRealm(), context.getUser(), (CredentialInput)UserCredentialModel.password((String)passwordNew, (boolean)false));
            context.success();
        }
        catch (ModelException me) {
            errorEvent.detail("reason", me.getMessage()).error("password_rejected");
            Response challenge = context.form().setAttribute("username", (Object)context.getAuthenticationSession().getAuthenticatedUser().getUsername()).setError(me.getMessage(), me.getParameters()).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            context.challenge(challenge);
            return;
        }
        catch (Exception ape) {
            errorEvent.detail("reason", ape.getMessage()).error("password_rejected");
            Response challenge = context.form().setAttribute("username", (Object)context.getAuthenticationSession().getAuthenticatedUser().getUsername()).setError(ape.getMessage(), new Object[0]).createResponse(UserModel.RequiredAction.UPDATE_PASSWORD);
            context.challenge(challenge);
            return;
        }
    }

    public void close() {
    }

    public RequiredActionProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public String getDisplayText() {
        return "Update Password";
    }

    public String getId() {
        return UserModel.RequiredAction.UPDATE_PASSWORD.name();
    }

    public boolean isOneTimeAction() {
        return true;
    }
}

