/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml;

import java.net.URI;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.util.TreeSet;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.broker.provider.AbstractIdentityProvider;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderDataMarshaller;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.broker.saml.SAMLDataMarshaller;
import org.keycloak.broker.saml.SAMLEndpoint;
import org.keycloak.broker.saml.SAMLIdentityProviderConfig;
import org.keycloak.common.util.PemUtils;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.events.EventBuilder;
import org.keycloak.keys.KeyMetadata;
import org.keycloak.keys.RsaKeyMetadata;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.saml.JaxrsSAML2BindingBuilder;
import org.keycloak.saml.SAML2AuthnRequestBuilder;
import org.keycloak.saml.SAML2LogoutRequestBuilder;
import org.keycloak.saml.SAML2NameIDPolicyBuilder;
import org.keycloak.saml.SPMetadataDescriptor;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.processing.core.util.KeycloakKeySamlExtensionGenerator;
import org.keycloak.sessions.AuthenticationSessionModel;

public class SAMLIdentityProvider
extends AbstractIdentityProvider<SAMLIdentityProviderConfig> {
    protected static final Logger logger = Logger.getLogger(SAMLIdentityProvider.class);

    public SAMLIdentityProvider(KeycloakSession session, SAMLIdentityProviderConfig config) {
        super(session, (IdentityProviderModel)config);
    }

    public Object callback(RealmModel realm, IdentityProvider.AuthenticationCallback callback, EventBuilder event) {
        return new SAMLEndpoint(realm, this, (SAMLIdentityProviderConfig)this.getConfig(), callback);
    }

    public Response performLogin(AuthenticationRequest request) {
        try {
            UriInfo uriInfo = request.getUriInfo();
            RealmModel realm = request.getRealm();
            String issuerURL = this.getEntityId(uriInfo, realm);
            String destinationUrl = ((SAMLIdentityProviderConfig)this.getConfig()).getSingleSignOnServiceUrl();
            String nameIDPolicyFormat = ((SAMLIdentityProviderConfig)this.getConfig()).getNameIDPolicyFormat();
            if (nameIDPolicyFormat == null) {
                nameIDPolicyFormat = JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get();
            }
            String protocolBinding = JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get();
            String assertionConsumerServiceUrl = request.getRedirectUri();
            if (((SAMLIdentityProviderConfig)this.getConfig()).isPostBindingResponse()) {
                protocolBinding = JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get();
            }
            SAML2AuthnRequestBuilder authnRequestBuilder = new SAML2AuthnRequestBuilder().assertionConsumerUrl(assertionConsumerServiceUrl).destination(destinationUrl).issuer(issuerURL).forceAuthn(((SAMLIdentityProviderConfig)this.getConfig()).isForceAuthn()).protocolBinding(protocolBinding).nameIdPolicy(SAML2NameIDPolicyBuilder.format((String)nameIDPolicyFormat));
            JaxrsSAML2BindingBuilder binding = (JaxrsSAML2BindingBuilder)new JaxrsSAML2BindingBuilder().relayState(request.getState().getEncoded());
            boolean postBinding = ((SAMLIdentityProviderConfig)this.getConfig()).isPostBindingAuthnRequest();
            if (((SAMLIdentityProviderConfig)this.getConfig()).isWantAuthnRequestsSigned()) {
                KeyManager.ActiveRsaKey keys = this.session.keys().getActiveRsaKey(realm);
                KeyPair keypair = new KeyPair(keys.getPublicKey(), keys.getPrivateKey());
                String keyName = ((SAMLIdentityProviderConfig)this.getConfig()).getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
                binding.signWith(keyName, keypair);
                binding.signatureAlgorithm(this.getSignatureAlgorithm());
                binding.signDocument();
                if (!postBinding && ((SAMLIdentityProviderConfig)this.getConfig()).isAddExtensionsElementWithKeyInfo()) {
                    authnRequestBuilder.addExtension((SamlProtocolExtensionsAwareBuilder.NodeGenerator)new KeycloakKeySamlExtensionGenerator(keyName));
                }
            }
            if (postBinding) {
                return binding.postBinding(authnRequestBuilder.toDocument()).request(destinationUrl);
            }
            return binding.redirectBinding(authnRequestBuilder.toDocument()).request(destinationUrl);
        }
        catch (Exception e) {
            throw new IdentityBrokerException("Could not create authentication request.", (Throwable)e);
        }
    }

    private String getEntityId(UriInfo uriInfo, RealmModel realm) {
        return UriBuilder.fromUri((URI)uriInfo.getBaseUri()).path("realms").path(realm.getName()).build(new Object[0]).toString();
    }

    public void authenticationFinished(AuthenticationSessionModel authSession, BrokeredIdentityContext context) {
        AuthnStatementType authn;
        ResponseType responseType = (ResponseType)context.getContextData().get("SAML_LOGIN_RESPONSE");
        AssertionType assertion = (AssertionType)context.getContextData().get("SAML_ASSERTION");
        SubjectType subject = assertion.getSubject();
        SubjectType.STSubType subType = subject.getSubType();
        NameIDType subjectNameID = (NameIDType)subType.getBaseID();
        authSession.setUserSessionNote("SAML_FEDERATED_SUBJECT", subjectNameID.getValue());
        if (subjectNameID.getFormat() != null) {
            authSession.setUserSessionNote("SAML_FEDERATED_SUBJECT_NAMEFORMAT", subjectNameID.getFormat().toString());
        }
        if ((authn = (AuthnStatementType)context.getContextData().get("SAML_AUTHN_STATEMENT")) != null && authn.getSessionIndex() != null) {
            authSession.setUserSessionNote("SAML_FEDERATED_SESSION_INDEX", authn.getSessionIndex());
        }
    }

    public Response retrieveToken(KeycloakSession session, FederatedIdentityModel identity) {
        return Response.ok((Object)identity.getToken()).build();
    }

    public void backchannelLogout(KeycloakSession session, UserSessionModel userSession, UriInfo uriInfo, RealmModel realm) {
        String singleLogoutServiceUrl = ((SAMLIdentityProviderConfig)this.getConfig()).getSingleLogoutServiceUrl();
        if (singleLogoutServiceUrl == null || singleLogoutServiceUrl.trim().equals("") || !((SAMLIdentityProviderConfig)this.getConfig()).isBackchannelSupported()) {
            return;
        }
        SAML2LogoutRequestBuilder logoutBuilder = this.buildLogoutRequest(userSession, uriInfo, realm, singleLogoutServiceUrl);
        JaxrsSAML2BindingBuilder binding = this.buildLogoutBinding(session, userSession, realm);
        try {
            boolean success;
            int status = SimpleHttp.doPost((String)singleLogoutServiceUrl, (KeycloakSession)session).param("SAMLRequest", binding.postBinding(logoutBuilder.buildDocument()).encoded()).param("RelayState", userSession.getId()).asStatus();
            boolean bl = success = status >= 200 && status < 400;
            if (!success) {
                logger.warn((Object)("Failed saml backchannel broker logout to: " + singleLogoutServiceUrl));
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Failed saml backchannel broker logout to: " + singleLogoutServiceUrl), (Throwable)e);
        }
    }

    public Response keycloakInitiatedBrowserLogout(KeycloakSession session, UserSessionModel userSession, UriInfo uriInfo, RealmModel realm) {
        String singleLogoutServiceUrl = ((SAMLIdentityProviderConfig)this.getConfig()).getSingleLogoutServiceUrl();
        if (singleLogoutServiceUrl == null || singleLogoutServiceUrl.trim().equals("")) {
            return null;
        }
        if (((SAMLIdentityProviderConfig)this.getConfig()).isBackchannelSupported()) {
            this.backchannelLogout(session, userSession, uriInfo, realm);
            return null;
        }
        try {
            SAML2LogoutRequestBuilder logoutBuilder = this.buildLogoutRequest(userSession, uriInfo, realm, singleLogoutServiceUrl);
            JaxrsSAML2BindingBuilder binding = this.buildLogoutBinding(session, userSession, realm);
            if (((SAMLIdentityProviderConfig)this.getConfig()).isPostBindingLogout()) {
                return binding.postBinding(logoutBuilder.buildDocument()).request(singleLogoutServiceUrl);
            }
            return binding.redirectBinding(logoutBuilder.buildDocument()).request(singleLogoutServiceUrl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected SAML2LogoutRequestBuilder buildLogoutRequest(UserSessionModel userSession, UriInfo uriInfo, RealmModel realm, String singleLogoutServiceUrl) {
        SAML2LogoutRequestBuilder logoutBuilder = new SAML2LogoutRequestBuilder().assertionExpiration(realm.getAccessCodeLifespan()).issuer(this.getEntityId(uriInfo, realm)).sessionIndex(userSession.getNote("SAML_FEDERATED_SESSION_INDEX")).userPrincipal(userSession.getNote("SAML_FEDERATED_SUBJECT"), userSession.getNote("SAML_FEDERATED_SUBJECT_NAMEFORMAT")).destination(singleLogoutServiceUrl);
        return logoutBuilder;
    }

    private JaxrsSAML2BindingBuilder buildLogoutBinding(KeycloakSession session, UserSessionModel userSession, RealmModel realm) {
        JaxrsSAML2BindingBuilder binding = (JaxrsSAML2BindingBuilder)new JaxrsSAML2BindingBuilder().relayState(userSession.getId());
        if (((SAMLIdentityProviderConfig)this.getConfig()).isWantAuthnRequestsSigned()) {
            KeyManager.ActiveRsaKey keys = session.keys().getActiveRsaKey(realm);
            String keyName = ((SAMLIdentityProviderConfig)this.getConfig()).getXmlSigKeyInfoKeyNameTransformer().getKeyName(keys.getKid(), keys.getCertificate());
            ((JaxrsSAML2BindingBuilder)((JaxrsSAML2BindingBuilder)binding.signWith(keyName, keys.getPrivateKey(), keys.getPublicKey(), keys.getCertificate())).signatureAlgorithm(this.getSignatureAlgorithm())).signDocument();
        }
        return binding;
    }

    public Response export(UriInfo uriInfo, RealmModel realm, String format) {
        String authnBinding = JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get();
        if (((SAMLIdentityProviderConfig)this.getConfig()).isPostBindingAuthnRequest()) {
            authnBinding = JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get();
        }
        String endpoint = uriInfo.getBaseUriBuilder().path("realms").path(realm.getName()).path("broker").path(((SAMLIdentityProviderConfig)this.getConfig()).getAlias()).path("endpoint").build(new Object[0]).toString();
        boolean wantAuthnRequestsSigned = ((SAMLIdentityProviderConfig)this.getConfig()).isWantAuthnRequestsSigned();
        boolean wantAssertionsSigned = ((SAMLIdentityProviderConfig)this.getConfig()).isWantAssertionsSigned();
        boolean wantAssertionsEncrypted = ((SAMLIdentityProviderConfig)this.getConfig()).isWantAssertionsEncrypted();
        String entityId = this.getEntityId(uriInfo, realm);
        String nameIDPolicyFormat = ((SAMLIdentityProviderConfig)this.getConfig()).getNameIDPolicyFormat();
        StringBuilder signingKeysString = new StringBuilder();
        StringBuilder encryptionKeysString = new StringBuilder();
        TreeSet keys = new TreeSet((o1, o2) -> o1.getStatus() == o2.getStatus() ? (int)(o2.getProviderPriority() - o1.getProviderPriority()) : (o1.getStatus() == KeyMetadata.Status.PASSIVE ? 1 : -1));
        keys.addAll(this.session.keys().getRsaKeys(realm, false));
        for (RsaKeyMetadata key : keys) {
            SAMLIdentityProvider.addKeyInfo(signingKeysString, key, KeyTypes.SIGNING.value());
            if (key.getStatus() != KeyMetadata.Status.ACTIVE) continue;
            SAMLIdentityProvider.addKeyInfo(encryptionKeysString, key, KeyTypes.ENCRYPTION.value());
        }
        String descriptor = SPMetadataDescriptor.getSPDescriptor((String)authnBinding, (String)endpoint, (String)endpoint, (boolean)wantAuthnRequestsSigned, (boolean)wantAssertionsSigned, (boolean)wantAssertionsEncrypted, (String)entityId, (String)nameIDPolicyFormat, (String)signingKeysString.toString(), (String)encryptionKeysString.toString());
        return Response.ok((Object)descriptor, (MediaType)MediaType.APPLICATION_XML_TYPE).build();
    }

    private static void addKeyInfo(StringBuilder target, RsaKeyMetadata key, String purpose) {
        if (key == null) {
            return;
        }
        target.append(SPMetadataDescriptor.xmlKeyInfo((String)"        ", (String)key.getKid(), (String)PemUtils.encodeCertificate((Certificate)key.getCertificate()), (String)purpose, (boolean)true));
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        SignatureAlgorithm algorithm;
        String alg = ((SAMLIdentityProviderConfig)this.getConfig()).getSignatureAlgorithm();
        if (alg != null && (algorithm = SignatureAlgorithm.valueOf((String)alg)) != null) {
            return algorithm;
        }
        return SignatureAlgorithm.RSA_SHA256;
    }

    public IdentityProviderDataMarshaller getMarshaller() {
        return new SAMLDataMarshaller();
    }
}

