/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.login.freemarker;

import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.authentication.requiredactions.util.UpdateProfileContext;
import org.keycloak.authentication.requiredactions.util.UserUpdateProfileContext;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.forms.login.LoginFormsPages;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.forms.login.freemarker.AuthenticatorConfiguredMethod;
import org.keycloak.forms.login.freemarker.LoginFormsUtil;
import org.keycloak.forms.login.freemarker.Templates;
import org.keycloak.forms.login.freemarker.model.ClientBean;
import org.keycloak.forms.login.freemarker.model.CodeBean;
import org.keycloak.forms.login.freemarker.model.IdentityProviderBean;
import org.keycloak.forms.login.freemarker.model.LoginBean;
import org.keycloak.forms.login.freemarker.model.OAuthGrantBean;
import org.keycloak.forms.login.freemarker.model.ProfileBean;
import org.keycloak.forms.login.freemarker.model.RealmBean;
import org.keycloak.forms.login.freemarker.model.RegisterBean;
import org.keycloak.forms.login.freemarker.model.RequiredActionUrlFormatterMethod;
import org.keycloak.forms.login.freemarker.model.TotpBean;
import org.keycloak.forms.login.freemarker.model.UrlBean;
import org.keycloak.models.ClientModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.FormMessage;
import org.keycloak.services.Urls;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.theme.BrowserSecurityHeaderSetup;
import org.keycloak.theme.FreeMarkerException;
import org.keycloak.theme.FreeMarkerUtil;
import org.keycloak.theme.Theme;
import org.keycloak.theme.ThemeProvider;
import org.keycloak.theme.beans.AdvancedMessageFormatterMethod;
import org.keycloak.theme.beans.LocaleBean;
import org.keycloak.theme.beans.MessageBean;
import org.keycloak.theme.beans.MessageFormatterMethod;
import org.keycloak.theme.beans.MessageType;
import org.keycloak.theme.beans.MessagesPerFieldBean;
import org.keycloak.utils.MediaType;

public class FreeMarkerLoginFormsProvider
implements LoginFormsProvider {
    private static final Logger logger = Logger.getLogger(FreeMarkerLoginFormsProvider.class);
    protected String accessCode;
    protected Response.Status status;
    protected List<RoleModel> realmRolesRequested;
    protected MultivaluedMap<String, RoleModel> resourceRolesRequested;
    protected List<ProtocolMapperModel> protocolMappersRequested;
    protected Map<String, String> httpResponseHeaders = new HashMap<String, String>();
    protected String accessRequestMessage;
    protected URI actionUri;
    protected String execution;
    protected List<FormMessage> messages = null;
    protected MessageType messageType = MessageType.ERROR;
    protected MultivaluedMap<String, String> formData;
    protected KeycloakSession session;
    protected AuthenticationSessionModel authenticationSession;
    protected RealmModel realm;
    protected ClientModel client;
    protected UriInfo uriInfo;
    protected FreeMarkerUtil freeMarker;
    protected UserModel user;
    protected final Map<String, Object> attributes = new HashMap<String, Object>();

    public FreeMarkerLoginFormsProvider(KeycloakSession session, FreeMarkerUtil freeMarker) {
        this.session = session;
        this.freeMarker = freeMarker;
        this.attributes.put("scripts", new LinkedList());
        this.realm = session.getContext().getRealm();
        this.client = session.getContext().getClient();
        this.uriInfo = session.getContext().getUri();
    }

    public void addScript(String scriptUrl) {
        List scripts = (List)this.attributes.get("scripts");
        scripts.add(scriptUrl);
    }

    public Response createResponse(UserModel.RequiredAction action) {
        LoginFormsPages page;
        String actionMessage;
        switch (action) {
            case CONFIGURE_TOTP: {
                actionMessage = "configureTotpMessage";
                page = LoginFormsPages.LOGIN_CONFIG_TOTP;
                break;
            }
            case UPDATE_PROFILE: {
                UserUpdateProfileContext userBasedContext = new UserUpdateProfileContext(this.realm, this.user);
                this.attributes.put("updateProfileCtx", userBasedContext);
                actionMessage = "updateProfileMessage";
                page = LoginFormsPages.LOGIN_UPDATE_PROFILE;
                break;
            }
            case UPDATE_PASSWORD: {
                boolean isRequestedByAdmin = this.user.getRequiredActions().stream().filter(Objects::nonNull).anyMatch(UserModel.RequiredAction.UPDATE_PASSWORD.toString()::contains);
                actionMessage = isRequestedByAdmin ? "updatePasswordMessage" : "resetPasswordMessage";
                page = LoginFormsPages.LOGIN_UPDATE_PASSWORD;
                break;
            }
            case VERIFY_EMAIL: {
                actionMessage = "verifyEmailMessage";
                page = LoginFormsPages.LOGIN_VERIFY_EMAIL;
                break;
            }
            default: {
                return Response.serverError().build();
            }
        }
        if (this.messages == null) {
            this.setMessage(MessageType.WARNING, actionMessage, new Object[0]);
        }
        return this.createResponse(page);
    }

    protected Response createResponse(LoginFormsPages page) {
        Theme theme;
        try {
            theme = this.getTheme();
        }
        catch (IOException e) {
            logger.error((Object)"Failed to create theme", (Throwable)e);
            return Response.serverError().build();
        }
        Locale locale = this.session.getContext().resolveLocale(this.user);
        Properties messagesBundle = this.handleThemeResources(theme, locale);
        this.handleMessages(locale, messagesBundle);
        UriBuilder uriBuilder = this.prepareBaseUriBuilder(page == LoginFormsPages.OAUTH_GRANT);
        this.createCommonAttributes(theme, locale, messagesBundle, uriBuilder, page);
        this.attributes.put("login", new LoginBean(this.formData));
        if (this.status != null) {
            this.attributes.put("statusCode", this.status.getStatusCode());
        }
        switch (page) {
            case LOGIN_CONFIG_TOTP: {
                this.attributes.put("totp", new TotpBean(this.session, this.realm, this.user, this.uriInfo.getRequestUriBuilder()));
                break;
            }
            case LOGIN_UPDATE_PROFILE: {
                UpdateProfileContext userCtx = (UpdateProfileContext)this.attributes.get("updateProfileCtx");
                this.attributes.put("user", new ProfileBean(userCtx, this.formData));
                break;
            }
            case LOGIN_IDP_LINK_CONFIRM: 
            case LOGIN_IDP_LINK_EMAIL: {
                BrokeredIdentityContext brokerContext = (BrokeredIdentityContext)this.attributes.get("identityProviderBrokerCtx");
                String idpAlias = brokerContext.getIdpConfig().getAlias();
                idpAlias = ObjectUtil.capitalize((String)idpAlias);
                this.attributes.put("brokerContext", brokerContext);
                this.attributes.put("idpAlias", idpAlias);
                break;
            }
            case REGISTER: {
                this.attributes.put("register", new RegisterBean(this.formData));
                break;
            }
            case OAUTH_GRANT: {
                this.attributes.put("oauth", new OAuthGrantBean(this.accessCode, this.client, this.realmRolesRequested, this.resourceRolesRequested, this.protocolMappersRequested, this.accessRequestMessage));
                this.attributes.put("advancedMsg", new AdvancedMessageFormatterMethod(locale, messagesBundle));
                break;
            }
            case CODE: {
                this.attributes.put("code", new CodeBean(this.accessCode, this.messageType == MessageType.ERROR ? this.getFirstMessageUnformatted() : null));
            }
        }
        return this.processTemplate(theme, Templates.getTemplate(page), locale);
    }

    public Response createForm(String form) {
        Theme theme;
        try {
            theme = this.getTheme();
        }
        catch (IOException e) {
            logger.error((Object)"Failed to create theme", (Throwable)e);
            return Response.serverError().build();
        }
        Locale locale = this.session.getContext().resolveLocale(this.user);
        Properties messagesBundle = this.handleThemeResources(theme, locale);
        this.handleMessages(locale, messagesBundle);
        UriBuilder uriBuilder = this.prepareBaseUriBuilder(false);
        this.createCommonAttributes(theme, locale, messagesBundle, uriBuilder, null);
        return this.processTemplate(theme, form, locale);
    }

    protected UriBuilder prepareBaseUriBuilder(boolean resetRequestUriParams) {
        String requestURI = this.uriInfo.getBaseUri().getPath();
        UriBuilder uriBuilder = UriBuilder.fromUri((String)requestURI);
        if (resetRequestUriParams) {
            uriBuilder.replaceQuery(null);
        }
        if (this.client != null) {
            uriBuilder.queryParam("client_id", new Object[]{this.client.getClientId()});
        }
        if (this.authenticationSession != null) {
            uriBuilder.queryParam("tab_id", new Object[]{this.authenticationSession.getTabId()});
        }
        return uriBuilder;
    }

    protected Theme getTheme() throws IOException {
        ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
        return themeProvider.getTheme(this.realm.getLoginTheme(), Theme.Type.LOGIN);
    }

    protected Properties handleThemeResources(Theme theme, Locale locale) {
        Properties messagesBundle;
        try {
            messagesBundle = theme.getMessages(locale);
            this.attributes.put("msg", new MessageFormatterMethod(locale, messagesBundle));
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load messages", (Throwable)e);
            messagesBundle = new Properties();
        }
        try {
            this.attributes.put("properties", theme.getProperties());
        }
        catch (IOException e) {
            logger.warn((Object)"Failed to load properties", (Throwable)e);
        }
        return messagesBundle;
    }

    protected void handleMessages(Locale locale, Properties messagesBundle) {
        MessagesPerFieldBean messagesPerField = new MessagesPerFieldBean();
        if (this.messages != null) {
            MessageBean wholeMessage = new MessageBean(null, this.messageType);
            for (FormMessage message : this.messages) {
                String formattedMessageText = this.formatMessage(message, messagesBundle, locale);
                if (formattedMessageText == null) continue;
                wholeMessage.appendSummaryLine(formattedMessageText);
                messagesPerField.addMessage(message.getField(), formattedMessageText, this.messageType);
            }
            this.attributes.put("message", wholeMessage);
        } else {
            this.attributes.put("message", null);
        }
        this.attributes.put("messagesPerField", messagesPerField);
    }

    protected void createCommonAttributes(Theme theme, Locale locale, Properties messagesBundle, UriBuilder baseUriBuilder, LoginFormsPages page) {
        URI baseUri = baseUriBuilder.build(new Object[0]);
        if (this.accessCode != null) {
            baseUriBuilder.queryParam("code", new Object[]{this.accessCode});
        }
        URI baseUriWithCodeAndClientId = baseUriBuilder.build(new Object[0]);
        if (this.client != null) {
            this.attributes.put("client", new ClientBean(this.client, baseUri));
        }
        if (this.realm != null) {
            this.attributes.put("realm", new RealmBean(this.realm));
            List<IdentityProviderModel> identityProviders = this.realm.getIdentityProviders();
            identityProviders = LoginFormsUtil.filterIdentityProviders(identityProviders, this.session, this.realm, this.attributes, this.formData);
            this.attributes.put("social", new IdentityProviderBean(this.realm, this.session, identityProviders, baseUriWithCodeAndClientId));
            this.attributes.put("url", new UrlBean(this.realm, theme, baseUri, this.actionUri));
            this.attributes.put("requiredActionUrl", new RequiredActionUrlFormatterMethod(this.realm, baseUri));
            if (this.realm.isInternationalizationEnabled()) {
                UriBuilder b;
                if (page != null) {
                    switch (page) {
                        case LOGIN: {
                            b = UriBuilder.fromUri((URI)Urls.realmLoginPage(baseUri, this.realm.getName()));
                            break;
                        }
                        case REGISTER: {
                            b = UriBuilder.fromUri((URI)Urls.realmRegisterPage(baseUri, this.realm.getName()));
                            break;
                        }
                        default: {
                            b = UriBuilder.fromUri((URI)baseUri).path(this.uriInfo.getPath());
                            break;
                        }
                    }
                } else {
                    b = UriBuilder.fromUri((URI)baseUri).path(this.uriInfo.getPath());
                }
                if (this.execution != null) {
                    b.queryParam("execution", new Object[]{this.execution});
                }
                this.attributes.put("locale", new LocaleBean(this.realm, locale, b, messagesBundle));
            }
        }
        if (this.realm != null && this.user != null && this.session != null) {
            this.attributes.put("authenticatorConfigured", new AuthenticatorConfiguredMethod(this.realm, this.user, this.session));
        }
    }

    protected Response processTemplate(Theme theme, String templateName, Locale locale) {
        try {
            String result = this.freeMarker.processTemplate(this.attributes, templateName, theme);
            Response.ResponseBuilder builder = Response.status((Response.Status)(this.status == null ? Response.Status.OK : this.status)).type(MediaType.TEXT_HTML_UTF_8_TYPE).language(locale).entity((Object)result);
            BrowserSecurityHeaderSetup.headers(builder, this.realm);
            for (Map.Entry<String, String> entry : this.httpResponseHeaders.entrySet()) {
                builder.header(entry.getKey(), (Object)entry.getValue());
            }
            return builder.build();
        }
        catch (FreeMarkerException e) {
            logger.error((Object)"Failed to process template", (Throwable)e);
            return Response.serverError().build();
        }
    }

    public Response createLogin() {
        return this.createResponse(LoginFormsPages.LOGIN);
    }

    public Response createPasswordReset() {
        return this.createResponse(LoginFormsPages.LOGIN_RESET_PASSWORD);
    }

    public Response createLoginTotp() {
        return this.createResponse(LoginFormsPages.LOGIN_TOTP);
    }

    public Response createRegistration() {
        return this.createResponse(LoginFormsPages.REGISTER);
    }

    public Response createInfoPage() {
        return this.createResponse(LoginFormsPages.INFO);
    }

    public Response createUpdateProfilePage() {
        if (this.messageType != MessageType.ERROR) {
            this.setMessage(MessageType.WARNING, "updateProfileMessage", new Object[0]);
        }
        return this.createResponse(LoginFormsPages.LOGIN_UPDATE_PROFILE);
    }

    public Response createIdpLinkConfirmLinkPage() {
        return this.createResponse(LoginFormsPages.LOGIN_IDP_LINK_CONFIRM);
    }

    public Response createLoginExpiredPage() {
        return this.createResponse(LoginFormsPages.LOGIN_PAGE_EXPIRED);
    }

    public Response createIdpLinkEmailPage() {
        BrokeredIdentityContext brokerContext = (BrokeredIdentityContext)this.attributes.get("identityProviderBrokerCtx");
        String idpAlias = brokerContext.getIdpConfig().getAlias();
        idpAlias = ObjectUtil.capitalize((String)idpAlias);
        this.setMessage(MessageType.WARNING, "linkIdpMessage", idpAlias);
        return this.createResponse(LoginFormsPages.LOGIN_IDP_LINK_EMAIL);
    }

    public Response createErrorPage(Response.Status status) {
        this.status = status;
        return this.createResponse(LoginFormsPages.ERROR);
    }

    public Response createOAuthGrant() {
        return this.createResponse(LoginFormsPages.OAUTH_GRANT);
    }

    public Response createCode() {
        return this.createResponse(LoginFormsPages.CODE);
    }

    protected void setMessage(MessageType type, String message, Object ... parameters) {
        this.messageType = type;
        this.messages = new ArrayList<FormMessage>();
        this.messages.add(new FormMessage(null, message, parameters));
    }

    protected String getFirstMessageUnformatted() {
        if (this.messages != null && !this.messages.isEmpty()) {
            return this.messages.get(0).getMessage();
        }
        return null;
    }

    protected String formatMessage(FormMessage message, Properties messagesBundle, Locale locale) {
        if (message == null) {
            return null;
        }
        if (messagesBundle.containsKey(message.getMessage())) {
            return new MessageFormat(messagesBundle.getProperty(message.getMessage()), locale).format(message.getParameters());
        }
        return message.getMessage();
    }

    public FreeMarkerLoginFormsProvider setError(String message, Object ... parameters) {
        this.setMessage(MessageType.ERROR, message, parameters);
        return this;
    }

    public LoginFormsProvider setErrors(List<FormMessage> messages) {
        if (messages == null) {
            return this;
        }
        this.messageType = MessageType.ERROR;
        this.messages = new ArrayList<FormMessage>(messages);
        return this;
    }

    public LoginFormsProvider addError(FormMessage errorMessage) {
        if (this.messageType != MessageType.ERROR) {
            this.messageType = null;
            this.messages = null;
        }
        if (this.messages == null) {
            this.messageType = MessageType.ERROR;
            this.messages = new LinkedList<FormMessage>();
        }
        this.messages.add(errorMessage);
        return this;
    }

    public LoginFormsProvider addSuccess(FormMessage errorMessage) {
        if (this.messageType != MessageType.SUCCESS) {
            this.messageType = null;
            this.messages = null;
        }
        if (this.messages == null) {
            this.messageType = MessageType.SUCCESS;
            this.messages = new LinkedList<FormMessage>();
        }
        this.messages.add(errorMessage);
        return this;
    }

    public FreeMarkerLoginFormsProvider setSuccess(String message, Object ... parameters) {
        this.setMessage(MessageType.SUCCESS, message, parameters);
        return this;
    }

    public FreeMarkerLoginFormsProvider setInfo(String message, Object ... parameters) {
        this.setMessage(MessageType.INFO, message, parameters);
        return this;
    }

    public LoginFormsProvider setAuthenticationSession(AuthenticationSessionModel authenticationSession) {
        this.authenticationSession = authenticationSession;
        return this;
    }

    public FreeMarkerLoginFormsProvider setUser(UserModel user) {
        this.user = user;
        return this;
    }

    public FreeMarkerLoginFormsProvider setFormData(MultivaluedMap<String, String> formData) {
        this.formData = formData;
        return this;
    }

    public LoginFormsProvider setClientSessionCode(String accessCode) {
        this.accessCode = accessCode;
        return this;
    }

    public LoginFormsProvider setAccessRequest(List<RoleModel> realmRolesRequested, MultivaluedMap<String, RoleModel> resourceRolesRequested, List<ProtocolMapperModel> protocolMappersRequested) {
        this.realmRolesRequested = realmRolesRequested;
        this.resourceRolesRequested = resourceRolesRequested;
        this.protocolMappersRequested = protocolMappersRequested;
        return this;
    }

    public LoginFormsProvider setAccessRequest(String accessRequestMessage) {
        this.accessRequestMessage = accessRequestMessage;
        return this;
    }

    public LoginFormsProvider setAttribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public LoginFormsProvider setStatus(Response.Status status) {
        this.status = status;
        return this;
    }

    public LoginFormsProvider setActionUri(URI actionUri) {
        this.actionUri = actionUri;
        return this;
    }

    public LoginFormsProvider setExecution(String execution) {
        this.execution = execution;
        return this;
    }

    public LoginFormsProvider setResponseHeader(String headerName, String headerValue) {
        this.httpResponseHeaders.put(headerName, headerValue);
        return this;
    }

    public void close() {
    }
}

