/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.account;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventStoreProvider;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.account.ClientRepresentation;
import org.keycloak.representations.account.SessionRepresentation;
import org.keycloak.representations.account.UserRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.Auth;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.resources.Cors;
import org.keycloak.storage.ReadOnlyException;

public class AccountRestService {
    @Context
    private HttpRequest request;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;
    @Context
    protected ClientConnection clientConnection;
    private final KeycloakSession session;
    private final ClientModel client;
    private final EventBuilder event;
    private EventStoreProvider eventStore;
    private Auth auth;
    private final RealmModel realm;
    private final UserModel user;

    public AccountRestService(KeycloakSession session, Auth auth, ClientModel client, EventBuilder event) {
        this.session = session;
        this.auth = auth;
        this.realm = auth.getRealm();
        this.user = auth.getUser();
        this.client = client;
        this.event = event;
    }

    public void init() {
        this.eventStore = (EventStoreProvider)this.session.getProvider(EventStoreProvider.class);
    }

    @Path(value="/")
    @OPTIONS
    @NoCache
    public Response preflight() {
        return Cors.add(this.request, Response.ok()).auth().preflight().build();
    }

    @Path(value="/")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response account() {
        this.auth.requireOneOf("manage-account", "view-profile");
        UserModel user = this.auth.getUser();
        UserRepresentation rep = new UserRepresentation();
        rep.setUsername(user.getUsername());
        rep.setFirstName(user.getFirstName());
        rep.setLastName(user.getLastName());
        rep.setEmail(user.getEmail());
        rep.setEmailVerified(user.isEmailVerified());
        rep.setAttributes(user.getAttributes());
        return Cors.add(this.request, Response.ok((Object)rep)).auth().allowedOrigins(this.auth.getToken()).build();
    }

    @Path(value="/")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoCache
    public Response updateAccount(UserRepresentation userRep) {
        this.auth.require("manage-account");
        this.event.event(EventType.UPDATE_PROFILE).client(this.auth.getClient()).user(this.user);
        try {
            UserModel existing;
            boolean emailChanged;
            boolean usernameChanged;
            RealmModel realm = this.session.getContext().getRealm();
            boolean bl = usernameChanged = userRep.getUsername() != null && !userRep.getUsername().equals(this.user.getUsername());
            if (realm.isEditUsernameAllowed()) {
                if (usernameChanged) {
                    UserModel existing2 = this.session.users().getUserByUsername(userRep.getUsername(), realm);
                    if (existing2 != null) {
                        return ErrorResponse.exists("username_exists");
                    }
                    this.user.setUsername(userRep.getUsername());
                }
            } else if (usernameChanged) {
                return ErrorResponse.error("username_read_only", Response.Status.BAD_REQUEST);
            }
            boolean bl2 = emailChanged = userRep.getEmail() != null && !userRep.getEmail().equals(this.user.getEmail());
            if (emailChanged && !realm.isDuplicateEmailsAllowed() && (existing = this.session.users().getUserByEmail(userRep.getEmail(), realm)) != null) {
                return ErrorResponse.exists("email_exists");
            }
            if (realm.isRegistrationEmailAsUsername() && !realm.isDuplicateEmailsAllowed() && (existing = this.session.users().getUserByUsername(userRep.getEmail(), realm)) != null) {
                return ErrorResponse.exists("username_exists");
            }
            if (emailChanged) {
                String oldEmail = this.user.getEmail();
                this.user.setEmail(userRep.getEmail());
                this.user.setEmailVerified(false);
                this.event.clone().event(EventType.UPDATE_EMAIL).detail("previous_email", oldEmail).detail("updated_email", userRep.getEmail()).success();
                if (realm.isRegistrationEmailAsUsername()) {
                    this.user.setUsername(userRep.getEmail());
                }
            }
            this.user.setFirstName(userRep.getFirstName());
            this.user.setLastName(userRep.getLastName());
            if (userRep.getAttributes() != null) {
                for (String string : this.user.getAttributes().keySet()) {
                    if (userRep.getAttributes().containsKey(string)) continue;
                    this.user.removeAttribute(string);
                }
                for (Map.Entry entry : userRep.getAttributes().entrySet()) {
                    this.user.setAttribute((String)entry.getKey(), (List)entry.getValue());
                }
            }
            this.event.success();
            return Cors.add(this.request, Response.ok()).auth().allowedOrigins(this.auth.getToken()).build();
        }
        catch (ReadOnlyException e) {
            return ErrorResponse.error("user_read_only", Response.Status.BAD_REQUEST);
        }
    }

    @Path(value="/sessions")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    public Response sessions() {
        LinkedList<SessionRepresentation> reps = new LinkedList<SessionRepresentation>();
        List sessions = this.session.sessions().getUserSessions(this.realm, this.user);
        for (UserSessionModel s : sessions) {
            SessionRepresentation rep = new SessionRepresentation();
            rep.setId(s.getId());
            rep.setIpAddress(s.getIpAddress());
            rep.setStarted(s.getStarted());
            rep.setLastAccess(s.getLastSessionRefresh());
            rep.setExpires(s.getStarted() + this.realm.getSsoSessionMaxLifespan());
            rep.setClients(new LinkedList());
            for (String clientUUID : s.getAuthenticatedClientSessions().keySet()) {
                ClientModel client = this.realm.getClientById(clientUUID);
                ClientRepresentation clientRep = new ClientRepresentation();
                clientRep.setClientId(client.getClientId());
                clientRep.setClientName(client.getName());
                rep.getClients().add(clientRep);
            }
            reps.add(rep);
        }
        return Cors.add(this.request, Response.ok(reps)).auth().allowedOrigins(this.auth.getToken()).build();
    }

    @Path(value="/sessions")
    @DELETE
    @Produces(value={"application/json"})
    @NoCache
    public Response sessionsLogout(@QueryParam(value="current") boolean removeCurrent) {
        UserSessionModel userSession = this.auth.getSession();
        List userSessions = this.session.sessions().getUserSessions(this.realm, this.user);
        for (UserSessionModel s : userSessions) {
            if (!removeCurrent && s.getId().equals(userSession.getId())) continue;
            AuthenticationManager.backchannelLogout(this.session, s, true);
        }
        return Cors.add(this.request, Response.ok()).auth().allowedOrigins(this.auth.getToken()).build();
    }
}

