/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.admin.representation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.common.KeycloakIdentity;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.util.Permissions;
import org.keycloak.models.ClientModel;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.idm.authorization.DecisionEffect;
import org.keycloak.representations.idm.authorization.PolicyEvaluationResponse;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;

public class PolicyEvaluationResponseBuilder {
    public static PolicyEvaluationResponse build(List<Result> results, ResourceServer resourceServer, AuthorizationProvider authorization, KeycloakIdentity identity) {
        PolicyEvaluationResponse response = new PolicyEvaluationResponse();
        ArrayList<PolicyEvaluationResponse.EvaluationResultRepresentation> resultsRep = new ArrayList<PolicyEvaluationResponse.EvaluationResultRepresentation>();
        AccessToken accessToken = identity.getAccessToken();
        AccessToken.Authorization authorizationData = new AccessToken.Authorization();
        authorizationData.setPermissions(Permissions.permits(results, null, authorization, resourceServer));
        accessToken.setAuthorization(authorizationData);
        ClientModel clientModel = authorization.getRealm().getClientById(resourceServer.getId());
        if (!accessToken.hasAudience(clientModel.getClientId())) {
            accessToken.audience(new String[]{clientModel.getClientId()});
        }
        response.setRpt(accessToken);
        if (results.stream().anyMatch(evaluationResult -> evaluationResult.getEffect().equals((Object)Decision.Effect.DENY))) {
            response.setStatus(DecisionEffect.DENY);
        } else {
            response.setStatus(DecisionEffect.PERMIT);
        }
        for (Result result : results) {
            ResourceRepresentation resource;
            PolicyEvaluationResponse.EvaluationResultRepresentation rep = new PolicyEvaluationResponse.EvaluationResultRepresentation();
            if (result.getEffect() == Decision.Effect.DENY) {
                rep.setStatus(DecisionEffect.DENY);
            } else {
                rep.setStatus(DecisionEffect.PERMIT);
            }
            resultsRep.add(rep);
            if (result.getPermission().getResource() != null) {
                resource = new ResourceRepresentation();
                resource.setId(result.getPermission().getResource().getId());
                resource.setName(result.getPermission().getResource().getName());
                rep.setResource(resource);
            } else {
                resource = new ResourceRepresentation();
                resource.setName("Any Resource with Scopes " + result.getPermission().getScopes().stream().map(Scope::getName).collect(Collectors.toList()));
                rep.setResource(resource);
            }
            rep.setScopes(result.getPermission().getScopes().stream().map(scope -> {
                ScopeRepresentation representation = new ScopeRepresentation();
                representation.setId(scope.getId());
                representation.setName(scope.getName());
                return representation;
            }).collect(Collectors.toList()));
            ArrayList<PolicyEvaluationResponse.PolicyResultRepresentation> policies = new ArrayList<PolicyEvaluationResponse.PolicyResultRepresentation>();
            for (Result.PolicyResult policy : result.getResults()) {
                PolicyEvaluationResponse.PolicyResultRepresentation policyRep = PolicyEvaluationResponseBuilder.toRepresentation(policy, authorization);
                if ("resource".equals(policy.getPolicy().getType())) {
                    policyRep.getPolicy().setScopes(result.getPermission().getResource().getScopes().stream().map(Scope::getName).collect(Collectors.toSet()));
                }
                policies.add(policyRep);
            }
            rep.setPolicies(policies);
        }
        resultsRep.sort(Comparator.comparing(o -> o.getResource().getName()));
        HashMap groupedResults = new HashMap();
        resultsRep.forEach(evaluationResultRepresentation -> {
            PolicyEvaluationResponse.EvaluationResultRepresentation result = (PolicyEvaluationResponse.EvaluationResultRepresentation)groupedResults.get(evaluationResultRepresentation.getResource().getId());
            ResourceRepresentation resource = evaluationResultRepresentation.getResource();
            if (result == null) {
                groupedResults.put(resource.getId(), evaluationResultRepresentation);
                result = evaluationResultRepresentation;
            }
            if (result.getStatus().equals((Object)DecisionEffect.PERMIT) || evaluationResultRepresentation.getStatus().equals((Object)DecisionEffect.PERMIT) && result.getStatus().equals((Object)DecisionEffect.DENY)) {
                result.setStatus(DecisionEffect.PERMIT);
            }
            List scopes = result.getScopes();
            if (DecisionEffect.PERMIT.equals((Object)result.getStatus())) {
                result.setAllowedScopes(scopes);
            }
            if (resource.getId() != null) {
                if (!scopes.isEmpty()) {
                    result.getResource().setName(evaluationResultRepresentation.getResource().getName() + " with scopes " + scopes.stream().flatMap(scopeRepresentation -> Arrays.asList(scopeRepresentation.getName()).stream()).collect(Collectors.toList()));
                } else {
                    result.getResource().setName(evaluationResultRepresentation.getResource().getName());
                }
            } else {
                result.getResource().setName("Any Resource with Scopes " + scopes.stream().flatMap(scopeRepresentation -> Arrays.asList(scopeRepresentation.getName()).stream()).collect(Collectors.toList()));
            }
            List policies = result.getPolicies();
            for (PolicyEvaluationResponse.PolicyResultRepresentation policy : new ArrayList(evaluationResultRepresentation.getPolicies())) {
                if (policies.contains(policy)) continue;
                policies.add(policy);
            }
        });
        response.setResults(groupedResults.values().stream().collect(Collectors.toList()));
        return response;
    }

    private static PolicyEvaluationResponse.PolicyResultRepresentation toRepresentation(Result.PolicyResult policy, AuthorizationProvider authorization) {
        PolicyEvaluationResponse.PolicyResultRepresentation policyResultRep = new PolicyEvaluationResponse.PolicyResultRepresentation();
        PolicyRepresentation representation = new PolicyRepresentation();
        representation.setId(policy.getPolicy().getId());
        representation.setName(policy.getPolicy().getName());
        representation.setType(policy.getPolicy().getType());
        representation.setDecisionStrategy(policy.getPolicy().getDecisionStrategy());
        representation.setResources(policy.getPolicy().getResources().stream().map(resource -> resource.getName()).collect(Collectors.toSet()));
        Set scopeNames = policy.getPolicy().getScopes().stream().map(scope -> scope.getName()).collect(Collectors.toSet());
        representation.setScopes(scopeNames);
        policyResultRep.setPolicy(representation);
        if (policy.getStatus() == Decision.Effect.DENY) {
            policyResultRep.setStatus(DecisionEffect.DENY);
            policyResultRep.setScopes(representation.getScopes());
        } else {
            policyResultRep.setStatus(DecisionEffect.PERMIT);
        }
        policyResultRep.setAssociatedPolicies(policy.getAssociatedPolicies().stream().map(result -> PolicyEvaluationResponseBuilder.toRepresentation(result, authorization)).collect(Collectors.toList()));
        return policyResultRep;
    }
}

