/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker;

import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.Profile;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.docker.DockerEndpoint;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.utils.ProfileHelper;

public class DockerV2LoginProtocolService {
    private final RealmModel realm;
    private final TokenManager tokenManager;
    private final EventBuilder event;
    @Context
    private UriInfo uriInfo;
    @Context
    private KeycloakSession session;
    @Context
    private HttpHeaders headers;

    public DockerV2LoginProtocolService(RealmModel realm, EventBuilder event) {
        this.realm = realm;
        this.tokenManager = new TokenManager();
        this.event = event;
    }

    public static UriBuilder authProtocolBaseUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return DockerV2LoginProtocolService.authProtocolBaseUrl(baseUriBuilder);
    }

    public static UriBuilder authProtocolBaseUrl(UriBuilder baseUriBuilder) {
        return baseUriBuilder.path(RealmsResource.class).path("{realm}/protocol/docker-v2");
    }

    public static UriBuilder authUrl(UriInfo uriInfo) {
        UriBuilder baseUriBuilder = uriInfo.getBaseUriBuilder();
        return DockerV2LoginProtocolService.authUrl(baseUriBuilder);
    }

    public static UriBuilder authUrl(UriBuilder baseUriBuilder) {
        UriBuilder uriBuilder = DockerV2LoginProtocolService.authProtocolBaseUrl(baseUriBuilder);
        return uriBuilder.path(DockerV2LoginProtocolService.class, "auth");
    }

    @Path(value="auth")
    public Object auth() {
        ProfileHelper.requireFeature(Profile.Feature.DOCKER);
        DockerEndpoint endpoint = new DockerEndpoint(this.realm, this.event, EventType.LOGIN);
        ResteasyProviderFactory.getInstance().injectProperties((Object)endpoint);
        return endpoint;
    }
}

