/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.filters;

import java.io.IOException;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.KeycloakTransactionManager;

public class KeycloakSessionServletFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        servletRequest.setCharacterEncoding("UTF-8");
        final HttpServletRequest request = (HttpServletRequest)servletRequest;
        KeycloakSessionFactory sessionFactory = (KeycloakSessionFactory)servletRequest.getServletContext().getAttribute(KeycloakSessionFactory.class.getName());
        KeycloakSession session = sessionFactory.create();
        ResteasyProviderFactory.pushContext(KeycloakSession.class, (Object)session);
        ClientConnection connection = new ClientConnection(){

            public String getRemoteAddr() {
                return request.getRemoteAddr();
            }

            public String getRemoteHost() {
                return request.getRemoteHost();
            }

            public int getRemotePort() {
                return request.getRemotePort();
            }

            public String getLocalAddr() {
                return request.getLocalAddr();
            }

            public int getLocalPort() {
                return request.getLocalPort();
            }
        };
        session.getContext().setConnection(connection);
        ResteasyProviderFactory.pushContext(ClientConnection.class, (Object)connection);
        KeycloakTransactionManager tx = session.getTransactionManager();
        ResteasyProviderFactory.pushContext(KeycloakTransaction.class, (Object)tx);
        tx.begin();
        try {
            filterChain.doFilter(servletRequest, servletResponse);
        }
        finally {
            if (servletRequest.isAsyncStarted()) {
                servletRequest.getAsyncContext().addListener(this.createAsyncLifeCycleListener(session));
            } else {
                this.closeSession(session);
            }
        }
    }

    private AsyncListener createAsyncLifeCycleListener(final KeycloakSession session) {
        return new AsyncListener(){

            public void onComplete(AsyncEvent event) {
                KeycloakSessionServletFilter.this.closeSession(session);
            }

            public void onTimeout(AsyncEvent event) {
                KeycloakSessionServletFilter.this.closeSession(session);
            }

            public void onError(AsyncEvent event) {
                KeycloakSessionServletFilter.this.closeSession(session);
            }

            public void onStartAsync(AsyncEvent event) {
            }
        };
    }

    private void closeSession(KeycloakSession session) {
        if (session.getTransactionManager() != null && session.getTransactionManager().isActive()) {
            session.getTransactionManager().rollback();
        }
        session.close();
        ResteasyProviderFactory.clearContextData();
    }

    public void destroy() {
    }
}

