/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import org.jboss.logging.Logger;
import org.keycloak.models.LDAPConstants;
import org.keycloak.services.ServicesLogger;

public class LDAPConnectionTestManager {
    private static final Logger logger = Logger.getLogger(LDAPConnectionTestManager.class);
    public static final String TEST_CONNECTION = "testConnection";
    public static final String TEST_AUTHENTICATION = "testAuthentication";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testLDAP(String action, String connectionUrl, String bindDn, String bindCredential, String useTruststoreSpi, String connectionTimeout) {
        if (!TEST_CONNECTION.equals(action) && !TEST_AUTHENTICATION.equals(action)) {
            ServicesLogger.LOGGER.unknownAction(action);
            return false;
        }
        Context ldapContext = null;
        try {
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            if (connectionUrl == null) {
                logger.errorf("Unknown connection URL", new Object[0]);
                boolean bl = false;
                return bl;
            }
            env.put("java.naming.provider.url", connectionUrl);
            if (TEST_AUTHENTICATION.equals(action)) {
                env.put("java.naming.security.authentication", "simple");
                if (bindDn == null) {
                    logger.error((Object)"Unknown bind DN");
                    boolean bl = false;
                    return bl;
                }
                env.put("java.naming.security.principal", bindDn);
                char[] bindCredentialChar = null;
                if (bindCredential != null) {
                    bindCredentialChar = bindCredential.toCharArray();
                }
                env.put("java.naming.security.credentials", bindCredentialChar);
            }
            LDAPConstants.setTruststoreSpiIfNeeded((String)useTruststoreSpi, (String)connectionUrl, env);
            if (connectionTimeout != null && !connectionTimeout.isEmpty()) {
                env.put("com.sun.jndi.ldap.connect.timeout", connectionTimeout);
            }
            ldapContext = new InitialLdapContext(env, null);
            boolean bindCredentialChar = true;
            return bindCredentialChar;
        }
        catch (Exception ne) {
            String errorMessage = TEST_AUTHENTICATION.equals(action) ? "Error when authenticating to LDAP: " : "Error when connecting to LDAP: ";
            ServicesLogger.LOGGER.errorAuthenticating(ne, errorMessage + ne.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (ldapContext != null) {
                try {
                    ldapContext.close();
                }
                catch (NamingException ne) {
                    ServicesLogger.LOGGER.errorClosingLDAP(ne);
                }
            }
        }
    }
}

