/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;

public class UserSessionCrossDCManager {
    private static final Logger logger = Logger.getLogger(UserSessionCrossDCManager.class);
    private final KeycloakSession kcSession;

    public UserSessionCrossDCManager(KeycloakSession session) {
        this.kcSession = session;
    }

    public UserSessionModel getUserSessionWithClient(RealmModel realm, String id, boolean offline, String clientUUID) {
        return this.kcSession.sessions().getUserSessionWithPredicate(realm, id, offline, userSession -> userSession.getAuthenticatedClientSessionByClient(clientUUID) != null);
    }

    public UserSessionModel getUserSessionWithClient(RealmModel realm, String id, String clientUUID) {
        return this.kcSession.sessions().getUserSessionWithPredicate(realm, id, false, userSession -> {
            AuthenticatedClientSessionModel authSessions = userSession.getAuthenticatedClientSessionByClient(clientUUID);
            return authSessions != null;
        });
    }

    public UserSessionModel getUserSessionIfExistsRemotely(RealmModel realm, String id) {
        UserSessionModel userSession = this.kcSession.sessions().getUserSession(realm, id);
        this.kcSession.sessions().getUserSessionWithPredicate(realm, id, false, userSession2 -> userSession2 == null);
        return this.kcSession.sessions().getUserSession(realm, id);
    }
}

