/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.keycloak.common.ClientConnection;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.storage.client.ClientStorageProvider;

public class ClientStorageProviderResource {
    private static final Logger logger = Logger.getLogger(ClientStorageProviderResource.class);
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected AdminEventBuilder adminEvent;
    @Context
    protected ClientConnection clientConnection;
    @Context
    protected UriInfo uriInfo;
    @Context
    protected KeycloakSession session;
    @Context
    protected HttpHeaders headers;

    public ClientStorageProviderResource(RealmModel realm, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.auth = auth;
        this.realm = realm;
        this.adminEvent = adminEvent;
    }

    @GET
    @Path(value="{id}/name")
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, String> getSimpleName(@PathParam(value="id") String id) {
        this.auth.clients().requireList();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        if (!model.getProviderType().equals(ClientStorageProvider.class.getName())) {
            throw new NotFoundException("found, but not a ClientStorageProvider");
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", model.getId());
        data.put("name", model.getName());
        return data;
    }
}

