/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.protection.resource;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.authorization.model.Resource;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.representations.idm.authorization.ScopeRepresentation;

public class UmaResourceRepresentation
extends ResourceRepresentation {
    public UmaResourceRepresentation() {
    }

    public UmaResourceRepresentation(ResourceRepresentation resource) {
        this.setId(resource.getId());
        this.setName(resource.getName());
        this.setType(resource.getType());
        this.setUri(resource.getUri());
        this.setIconUri(resource.getIconUri());
        this.setOwner(resource.getOwner());
        this.setScopes(resource.getScopes());
        this.setDisplayName(resource.getDisplayName());
        this.setOwnerManagedAccess(resource.getOwnerManagedAccess());
    }

    public UmaResourceRepresentation(Resource resource) {
        this.setId(resource.getId());
        this.setName(resource.getName());
        this.setType(resource.getType());
        this.setUri(resource.getUri());
        this.setIconUri(resource.getIconUri());
        this.setOwner(resource.getOwner());
        this.setScopes(resource.getScopes().stream().map(scope -> new ScopeRepresentation(scope.getName())).collect(Collectors.toSet()));
        this.setDisplayName(resource.getDisplayName());
        this.setOwnerManagedAccess(resource.isOwnerManagedAccess());
        this.setAttributes(resource.getAttributes());
    }

    @JsonProperty(value="resource_scopes")
    public Set<ScopeRepresentation> getScopes() {
        return super.getScopes();
    }

    @JsonProperty(value="resource_scopes")
    public void setScopes(Set<ScopeRepresentation> scopes) {
        super.setScopes(scopes);
    }
}

