/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.util;

import java.util.Locale;
import java.util.Set;

class LocaleNegotiator {
    private Set<String> supportedLocales;

    LocaleNegotiator(Set<String> supportedLocales) {
        this.supportedLocales = supportedLocales;
    }

    Locale invoke(String ... localeStrings) {
        for (String localeString : localeStrings) {
            if (localeString == null) continue;
            Locale result = null;
            Locale search = Locale.forLanguageTag(localeString);
            for (String languageTag : this.supportedLocales) {
                Locale locale = Locale.forLanguageTag(languageTag);
                if (!locale.getLanguage().equals(search.getLanguage())) continue;
                if (search.getCountry().equals("") ^ locale.getCountry().equals("") && result == null) {
                    result = locale;
                }
                if (!locale.getCountry().equals(search.getCountry())) continue;
                return locale;
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

