/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.protocol.HttpContext;
import org.jboss.logging.Logger;
import org.keycloak.connections.httpclient.ProxyMappings;

public class ProxyMappingsAwareRoutePlanner
extends DefaultRoutePlanner {
    private static final Logger LOG = Logger.getLogger(ProxyMappingsAwareRoutePlanner.class);
    private final ProxyMappings proxyMappings;

    public ProxyMappingsAwareRoutePlanner(ProxyMappings proxyMappings) {
        super((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
        this.proxyMappings = proxyMappings;
    }

    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        HttpHost proxy = this.proxyMappings.getProxyFor(target.getHostName());
        LOG.debugf("Returning proxy=%s for targetHost=%s", (Object)proxy, (Object)target.getHostName());
        return proxy;
    }
}

