/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.saml.mappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.keycloak.broker.provider.AbstractIdentityProviderMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderConfigProperty;

public class UserAttributeStatementMapper
extends AbstractIdentityProviderMapper {
    private static final String USER_ATTR_LOCALE = "locale";
    private static final String[] COMPATIBLE_PROVIDERS = new String[]{"saml"};
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();
    public static final String ATTRIBUTE_NAME_PATTERN = "attribute.name.pattern";
    public static final String USER_ATTRIBUTE_FIRST_NAME = "user.attribute.firstName";
    public static final String USER_ATTRIBUTE_LAST_NAME = "user.attribute.lastName";
    public static final String USER_ATTRIBUTE_EMAIL = "user.attribute.email";
    public static final String USER_ATTRIBUTE_LANGUAGE = "user.attribute.language";
    private static final String USE_FRIENDLY_NAMES = "use.friendly.names";
    public static final String PROVIDER_ID = "saml-user-attributestatement-idp-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String[] getCompatibleProviders() {
        return (String[])COMPATIBLE_PROVIDERS.clone();
    }

    public String getDisplayCategory() {
        return "AttributeStatement Importer";
    }

    public String getDisplayType() {
        return "AttributeStatement Importer";
    }

    public void preprocessFederatedIdentity(KeycloakSession session, RealmModel realm, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String firstNameAttribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE_FIRST_NAME);
        String lastNameAttribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE_LAST_NAME);
        String emailAttribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE_EMAIL);
        String langAttribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE_LANGUAGE);
        Boolean useFriendlyNames = Boolean.valueOf((String)mapperModel.getConfig().get(USE_FRIENDLY_NAMES));
        List<AttributeType> attributesInContext = this.findAttributesInContext(context, this.getAttributePattern(mapperModel));
        for (AttributeType a : attributesInContext) {
            String attribute;
            String string = attribute = useFriendlyNames != false ? a.getFriendlyName() : a.getName();
            List<String> attributeValuesInContext = a.getAttributeValue().stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
            if (attributeValuesInContext.isEmpty()) continue;
            context.setUserAttribute(attribute, attributeValuesInContext);
            if (Objects.equals(attribute, emailAttribute)) {
                this.setIfNotEmpty(arg_0 -> ((BrokeredIdentityContext)context).setEmail(arg_0), attributeValuesInContext);
                continue;
            }
            if (Objects.equals(attribute, firstNameAttribute)) {
                this.setIfNotEmpty(arg_0 -> ((BrokeredIdentityContext)context).setFirstName(arg_0), attributeValuesInContext);
                continue;
            }
            if (Objects.equals(attribute, lastNameAttribute)) {
                this.setIfNotEmpty(arg_0 -> ((BrokeredIdentityContext)context).setLastName(arg_0), attributeValuesInContext);
                continue;
            }
            if (!Objects.equals(attribute, langAttribute)) continue;
            context.setUserAttribute(USER_ATTR_LOCALE, attributeValuesInContext);
        }
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        String firstNameAttribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE_FIRST_NAME);
        String lastNameAttribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE_LAST_NAME);
        String emailAttribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE_EMAIL);
        String langAttribute = (String)mapperModel.getConfig().get(USER_ATTRIBUTE_LANGUAGE);
        Boolean useFriendlyNames = Boolean.valueOf((String)mapperModel.getConfig().get(USE_FRIENDLY_NAMES));
        List<AttributeType> attributesInContext = this.findAttributesInContext(context, this.getAttributePattern(mapperModel));
        HashSet<String> assertedUserAttributes = new HashSet<String>();
        for (AttributeType a2 : attributesInContext) {
            String attribute = useFriendlyNames != false ? a2.getFriendlyName() : a2.getName();
            List<String> attributeValuesInContext = a2.getAttributeValue().stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
            List currentAttributeValues = (List)user.getAttributes().get(attribute);
            if (attributeValuesInContext == null) {
                user.removeAttribute(attribute);
            } else if (currentAttributeValues == null) {
                user.setAttribute(attribute, attributeValuesInContext);
            } else if (!CollectionUtil.collectionEquals(attributeValuesInContext, (Collection)currentAttributeValues)) {
                user.setAttribute(attribute, attributeValuesInContext);
            }
            if (Objects.equals(attribute, emailAttribute)) {
                this.setIfNotEmpty(arg_0 -> ((BrokeredIdentityContext)context).setEmail(arg_0), attributeValuesInContext);
            } else if (Objects.equals(attribute, firstNameAttribute)) {
                this.setIfNotEmpty(arg_0 -> ((BrokeredIdentityContext)context).setFirstName(arg_0), attributeValuesInContext);
            } else if (Objects.equals(attribute, lastNameAttribute)) {
                this.setIfNotEmpty(arg_0 -> ((BrokeredIdentityContext)context).setLastName(arg_0), attributeValuesInContext);
            } else if (Objects.equals(attribute, langAttribute)) {
                if (attributeValuesInContext == null) {
                    user.removeAttribute(USER_ATTR_LOCALE);
                } else {
                    user.setAttribute(USER_ATTR_LOCALE, attributeValuesInContext);
                }
                assertedUserAttributes.add(USER_ATTR_LOCALE);
            }
            assertedUserAttributes.add(attribute);
        }
        user.getAttributes().keySet().stream().filter(a -> !assertedUserAttributes.contains(a)).forEach(a -> user.removeAttribute(a));
    }

    public String getHelpText() {
        return "Import all saml attributes found in attributestatements in assertion into user properties or attributes.";
    }

    private Optional<Pattern> getAttributePattern(IdentityProviderMapperModel mapperModel) {
        String attributePatternConfig = (String)mapperModel.getConfig().get(ATTRIBUTE_NAME_PATTERN);
        return Optional.ofNullable(attributePatternConfig != null ? Pattern.compile(attributePatternConfig) : null);
    }

    private List<AttributeType> findAttributesInContext(BrokeredIdentityContext context, Optional<Pattern> attributePattern) {
        AssertionType assertion = (AssertionType)context.getContextData().get("SAML_ASSERTION");
        return assertion.getAttributeStatements().stream().flatMap(statement -> statement.getAttributes().stream()).filter(item -> !attributePattern.isPresent() || ((Pattern)attributePattern.get()).matcher(item.getAttribute().getName()).matches()).map(AttributeStatementType.ASTChoiceType::getAttribute).collect(Collectors.toList());
    }

    private void setIfNotEmpty(Consumer<String> consumer, List<String> values) {
        if (values != null && !values.isEmpty()) {
            consumer.accept(values.get(0));
        }
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(ATTRIBUTE_NAME_PATTERN);
        property.setLabel("Attribute Name Pattern");
        property.setHelpText("Pattern of attribute names in assertion that must be mapped. Leave blank to map all attributes.");
        property.setType("String");
        CONFIG_PROPERTIES.add(property);
        property = new ProviderConfigProperty();
        property.setName(USER_ATTRIBUTE_FIRST_NAME);
        property.setLabel("User Attribute FirstName");
        property.setHelpText("Define which saml Attribute must be mapped to the User property firstName.");
        property.setType("String");
        CONFIG_PROPERTIES.add(property);
        property = new ProviderConfigProperty();
        property.setName(USER_ATTRIBUTE_LAST_NAME);
        property.setLabel("User Attribute LastName");
        property.setHelpText("Define which saml Attribute must be mapped to the User property lastName.");
        property.setType("String");
        CONFIG_PROPERTIES.add(property);
        property = new ProviderConfigProperty();
        property.setName(USER_ATTRIBUTE_EMAIL);
        property.setLabel("User Attribute Email");
        property.setHelpText("Define which saml Attribute must be mapped to the User property email.");
        property.setType("String");
        CONFIG_PROPERTIES.add(property);
        property = new ProviderConfigProperty();
        property.setName(USER_ATTRIBUTE_LANGUAGE);
        property.setLabel("User Attribute Language");
        property.setHelpText("Define which saml Attribute must be mapped to the User attribute locale.");
        property.setType("String");
        CONFIG_PROPERTIES.add(property);
        property = new ProviderConfigProperty();
        property.setName(USE_FRIENDLY_NAMES);
        property.setLabel("Use Attribute Friendly Name");
        property.setHelpText("Define which name to give to each mapped user attribute: name or friendlyName.");
        property.setType("boolean");
        CONFIG_PROPERTIES.add(property);
    }
}

