/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.forms.account.freemarker.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrderedModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;
import org.keycloak.storage.StorageId;

public class ApplicationsBean {
    private List<ApplicationEntry> applications = new LinkedList<ApplicationEntry>();

    public ApplicationsBean(KeycloakSession session, RealmModel realm, UserModel user) {
        Set<ClientModel> offlineClients = new UserSessionManager(session).findClientsWithOfflineToken(realm, user);
        for (ClientModel client : this.getApplications(session, realm, user)) {
            UserConsentModel consent;
            if (ApplicationsBean.isAdminClient(client) && !AdminPermissions.realms(session, realm, user).isAdmin()) continue;
            HashSet<ClientScopeModel> allClientScopes = new HashSet<ClientScopeModel>(client.getClientScopes(true, true).values());
            allClientScopes.addAll(client.getClientScopes(false, true).values());
            allClientScopes.add((ClientScopeModel)client);
            Set<RoleModel> availableRoles = TokenManager.getAccess(user, client, allClientScopes);
            if (!ApplicationsBean.isAdminClient(client) && availableRoles.isEmpty() && !client.isConsentRequired()) continue;
            LinkedList<RoleModel> realmRolesAvailable = new LinkedList<RoleModel>();
            MultivaluedHashMap resourceRolesAvailable = new MultivaluedHashMap();
            this.processRoles(availableRoles, realmRolesAvailable, (MultivaluedHashMap<String, ClientRoleEntry>)resourceRolesAvailable);
            LinkedList orderedScopes = new LinkedList();
            if (client.isConsentRequired() && (consent = session.users().getConsentByClient(realm, user.getId(), client.getId())) != null) {
                orderedScopes.addAll(consent.getGrantedClientScopes());
            }
            List<String> clientScopesGranted = orderedScopes.stream().sorted(OrderedModel.OrderedModelComparator.getInstance()).map(ClientScopeModel::getConsentScreenText).collect(Collectors.toList());
            ArrayList<String> additionalGrants = new ArrayList<String>();
            if (offlineClients.contains(client)) {
                additionalGrants.add("${offlineToken}");
            }
            this.applications.add(new ApplicationEntry(realmRolesAvailable, (MultivaluedHashMap<String, ClientRoleEntry>)resourceRolesAvailable, client, clientScopesGranted, additionalGrants));
        }
    }

    public static boolean isAdminClient(ClientModel client) {
        return client.getClientId().equals("admin-cli") || client.getClientId().equals("security-admin-console");
    }

    private Set<ClientModel> getApplications(KeycloakSession session, RealmModel realm, UserModel user) {
        HashSet<ClientModel> clients = new HashSet<ClientModel>();
        for (ClientModel client : realm.getClients()) {
            if (client.isBearerOnly()) continue;
            clients.add(client);
        }
        List consents = session.users().getConsents(realm, user.getId());
        for (UserConsentModel consent : consents) {
            ClientModel client = consent.getClient();
            if (new StorageId(client.getId()).isLocal()) continue;
            clients.add(client);
        }
        return clients;
    }

    private void processRoles(Set<RoleModel> inputRoles, List<RoleModel> realmRoles, MultivaluedHashMap<String, ClientRoleEntry> clientRoles) {
        for (RoleModel role : inputRoles) {
            if (role.getContainer() instanceof RealmModel) {
                realmRoles.add(role);
                continue;
            }
            ClientModel currentClient = (ClientModel)role.getContainer();
            ClientRoleEntry clientRole = new ClientRoleEntry(currentClient.getClientId(), currentClient.getName(), role.getName(), role.getDescription());
            clientRoles.add((Object)currentClient.getClientId(), (Object)clientRole);
        }
    }

    public List<ApplicationEntry> getApplications() {
        return this.applications;
    }

    public static class ClientRoleEntry {
        private final String clientId;
        private final String clientName;
        private final String roleName;
        private final String roleDescription;

        public ClientRoleEntry(String clientId, String clientName, String roleName, String roleDescription) {
            this.clientId = clientId;
            this.clientName = clientName;
            this.roleName = roleName;
            this.roleDescription = roleDescription;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientName() {
            return this.clientName;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public String getRoleDescription() {
            return this.roleDescription;
        }
    }

    public static class ApplicationEntry {
        private final List<RoleModel> realmRolesAvailable;
        private final MultivaluedHashMap<String, ClientRoleEntry> resourceRolesAvailable;
        private final ClientModel client;
        private final List<String> clientScopesGranted;
        private final List<String> additionalGrants;

        public ApplicationEntry(List<RoleModel> realmRolesAvailable, MultivaluedHashMap<String, ClientRoleEntry> resourceRolesAvailable, ClientModel client, List<String> clientScopesGranted, List<String> additionalGrants) {
            this.realmRolesAvailable = realmRolesAvailable;
            this.resourceRolesAvailable = resourceRolesAvailable;
            this.client = client;
            this.clientScopesGranted = clientScopesGranted;
            this.additionalGrants = additionalGrants;
        }

        public List<RoleModel> getRealmRolesAvailable() {
            return this.realmRolesAvailable;
        }

        public MultivaluedHashMap<String, ClientRoleEntry> getResourceRolesAvailable() {
            return this.resourceRolesAvailable;
        }

        public List<String> getClientScopesGranted() {
            return this.clientScopesGranted;
        }

        public String getEffectiveUrl() {
            String rootUrl = this.getClient().getRootUrl();
            String baseUrl = this.getClient().getBaseUrl();
            if (rootUrl == null) {
                rootUrl = "";
            }
            if (baseUrl == null) {
                baseUrl = "";
            }
            if (rootUrl.equals("") && baseUrl.equals("")) {
                return "";
            }
            if (rootUrl.equals("") && !baseUrl.equals("")) {
                return baseUrl;
            }
            if (!rootUrl.equals("") && baseUrl.equals("")) {
                return rootUrl;
            }
            if (this.isBaseUrlRelative() && !rootUrl.equals("")) {
                return this.concatUrls(rootUrl, baseUrl);
            }
            return baseUrl;
        }

        private String concatUrls(String u1, String u2) {
            if (u1.endsWith("/")) {
                u1 = u1.substring(0, u1.length() - 1);
            }
            if (u2.startsWith("/")) {
                u2 = u2.substring(1);
            }
            return u1 + "/" + u2;
        }

        private boolean isBaseUrlRelative() {
            String baseUrl = this.getClient().getBaseUrl();
            if (baseUrl.equals("")) {
                return false;
            }
            if (baseUrl.startsWith("/")) {
                return true;
            }
            if (baseUrl.startsWith("./")) {
                return true;
            }
            return baseUrl.startsWith("../");
        }

        public ClientModel getClient() {
            return this.client;
        }

        public List<String> getAdditionalGrants() {
            return this.additionalGrants;
        }
    }
}

