/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.x509;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.authentication.AuthenticatorFactory;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.ServicesLogger;

public abstract class AbstractX509ClientCertificateAuthenticatorFactory
implements AuthenticatorFactory {
    protected static ServicesLogger logger = ServicesLogger.LOGGER;
    private static final String[] mappingSources = new String[]{"Match SubjectDN using regular expression", "Subject's e-mail", "Subject's Alternative Name E-mail", "Subject's Alternative Name otherName (UPN)", "Subject's Common Name", "Match IssuerDN using regular expression", "Issuer's e-mail", "Issuer's Common Name", "Certificate Serial Number"};
    private static final String[] userModelMappers = new String[]{"Custom Attribute Mapper", "Username or Email"};
    protected static final List<ProviderConfigProperty> configProperties;

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getReferenceCategory() {
        return null;
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean isUserSetupAllowed() {
        return false;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    static {
        LinkedList<String> mappingSourceTypes = new LinkedList<String>();
        for (String s : mappingSources) {
            mappingSourceTypes.add(s);
        }
        ProviderConfigProperty mappingMethodList = new ProviderConfigProperty();
        mappingMethodList.setType("List");
        mappingMethodList.setName("x509-cert-auth.mapping-source-selection");
        mappingMethodList.setLabel("User Identity Source");
        mappingMethodList.setHelpText("Choose how to extract user identity from X509 certificate or the certificate fields. For example, SubjectDN will match the custom regular expression specified below to the value of certificate's SubjectDN field.");
        mappingMethodList.setDefaultValue((Object)mappingSources[0]);
        mappingMethodList.setOptions(mappingSourceTypes);
        ProviderConfigProperty canonicalDn = new ProviderConfigProperty();
        canonicalDn.setType("boolean");
        canonicalDn.setName("x509-cert-auth.canonical-dn-enabled");
        canonicalDn.setLabel("Canonical DN representation enabled");
        canonicalDn.setDefaultValue((Object)false);
        canonicalDn.setHelpText("Use the canonical format to determine the distinguished name. This option is relevant for authenticators using a distinguished name.");
        ProviderConfigProperty regExp = new ProviderConfigProperty();
        regExp.setType("String");
        regExp.setName("x509-cert-auth.regular-expression");
        regExp.setLabel("A regular expression to extract user identity");
        regExp.setDefaultValue((Object)"(.*?)(?:$)");
        regExp.setHelpText("The regular expression to extract a user identity. The expression must contain a single group. For example, 'uniqueId=(.*?)(?:,|$)' will match 'uniqueId=somebody@company.org, CN=somebody' and give somebody@company.org");
        LinkedList<String> mapperTypes = new LinkedList<String>();
        for (String m : userModelMappers) {
            mapperTypes.add(m);
        }
        ProviderConfigProperty userMapperList = new ProviderConfigProperty();
        userMapperList.setType("List");
        userMapperList.setName("x509-cert-auth.mapper-selection");
        userMapperList.setHelpText("Choose how to map extracted user identities to users");
        userMapperList.setLabel("User mapping method");
        userMapperList.setDefaultValue((Object)userModelMappers[0]);
        userMapperList.setOptions(mapperTypes);
        ProviderConfigProperty attributeOrPropertyValue = new ProviderConfigProperty();
        attributeOrPropertyValue.setType("String");
        attributeOrPropertyValue.setName("x509-cert-auth.mapper-selection.user-attribute-name");
        attributeOrPropertyValue.setDefaultValue((Object)"usercertificate");
        attributeOrPropertyValue.setLabel("A name of user attribute");
        attributeOrPropertyValue.setHelpText("A name of user attribute to map the extracted user identity to existing user. The name must be a valid, existing user attribute if User Mapping Method is set to Custom Attribute Mapper.");
        ProviderConfigProperty crlCheckingEnabled = new ProviderConfigProperty();
        crlCheckingEnabled.setType("boolean");
        crlCheckingEnabled.setName("x509-cert-auth.crl-checking-enabled");
        crlCheckingEnabled.setHelpText("Enable Certificate Revocation Checking using CRL");
        crlCheckingEnabled.setLabel("CRL Checking Enabled");
        ProviderConfigProperty crlDPEnabled = new ProviderConfigProperty();
        crlDPEnabled.setType("boolean");
        crlDPEnabled.setName("x509-cert-auth.crldp-checking-enabled");
        crlDPEnabled.setDefaultValue((Object)false);
        crlDPEnabled.setLabel("Enable CRL Distribution Point to check certificate revocation status");
        crlDPEnabled.setHelpText("CRL Distribution Point is a starting point for CRL. If this is ON, then CRL checking will be done based on the CRL distribution points included in the checked certificates. CDP is optional, but most PKI authorities include CDP in their certificates.");
        ProviderConfigProperty cRLRelativePath = new ProviderConfigProperty();
        cRLRelativePath.setType("MultivaluedString");
        cRLRelativePath.setName("x509-cert-auth.crl-relative-path");
        cRLRelativePath.setDefaultValue((Object)"crl.pem");
        cRLRelativePath.setLabel("CRL Path");
        cRLRelativePath.setHelpText("Applied just if CRL checking is ON and CRL Distribution point is OFF. It contains the URL (typically 'http' or 'ldap') where the CRL is available. Alternatively it can contain the path to a CRL file that contains a list of revoked certificates. Paths are assumed to be relative to $jboss.server.config.dir. Multiple CRLs can be included, however it can affect performance as the certificate will be checked against all listed CRLs.");
        ProviderConfigProperty oCspCheckingEnabled = new ProviderConfigProperty();
        oCspCheckingEnabled.setType("boolean");
        oCspCheckingEnabled.setName("x509-cert-auth.ocsp-checking-enabled");
        oCspCheckingEnabled.setHelpText("Enable Certificate Revocation Checking using OCSP");
        oCspCheckingEnabled.setLabel("OCSP Checking Enabled");
        ProviderConfigProperty ocspResponderUri = new ProviderConfigProperty();
        ocspResponderUri.setType("String");
        ocspResponderUri.setName("x509-cert-auth.ocsp-responder-uri");
        ocspResponderUri.setLabel("OCSP Responder Uri");
        ocspResponderUri.setHelpText("Clients use OCSP Responder Uri to check certificate revocation status.");
        ProviderConfigProperty ocspResponderCert = new ProviderConfigProperty();
        ocspResponderCert.setType("Text");
        ocspResponderCert.setName("x509-cert-auth.ocsp-responder-certificate");
        ocspResponderCert.setLabel("OCSP Responder Certificate");
        ocspResponderCert.setHelpText("Optional certificate used by the responder to sign the responses. The certificate should be in PEM format without BEGIN and END tags. It is only used if the OCSP Responder URI is set. By default, the certificate of the OCSP responder is that of the issuer of the certificate being validated or one with the OCSPSigning extension and also issued by the same CA. This option identifies the certificate of the OCSP responder when the defaults do not apply.");
        ProviderConfigProperty keyUsage = new ProviderConfigProperty();
        keyUsage.setType("String");
        keyUsage.setName("x509-cert-auth.keyusage");
        keyUsage.setLabel("Validate Key Usage");
        keyUsage.setHelpText("Validates that the purpose of the key contained in the certificate (encipherment, signature, etc.) matches its intended purpose. Leaving the field blank will disable Key Usage validation. For example, 'digitalSignature, keyEncipherment' will check if the digitalSignature and keyEncipherment bits (bit 0 and bit 2 respectively) are set in certificate's X509 Key Usage extension. See RFC 5280 for a detailed definition of X509 Key Usage extension.");
        ProviderConfigProperty extendedKeyUsage = new ProviderConfigProperty();
        extendedKeyUsage.setType("String");
        extendedKeyUsage.setName("x509-cert-auth.extendedkeyusage");
        extendedKeyUsage.setLabel("Validate Extended Key Usage");
        extendedKeyUsage.setHelpText("Validates the extended purposes of the certificate's key using certificate's Extended Key Usage extension. Leaving the field blank will disable Extended Key Usage validation. See RFC 5280 for a detailed definition of X509 Extended Key Usage extension.");
        ProviderConfigProperty identityConfirmationPageDisallowed = new ProviderConfigProperty();
        identityConfirmationPageDisallowed.setType("boolean");
        identityConfirmationPageDisallowed.setName("x509-cert-auth.confirmation-page-disallowed");
        identityConfirmationPageDisallowed.setLabel("Bypass identity confirmation");
        identityConfirmationPageDisallowed.setHelpText("By default, the users are prompted to confirm their identity extracted from X509 client certificate. The identity confirmation prompt is skipped if the option is switched on.");
        configProperties = Arrays.asList(mappingMethodList, canonicalDn, regExp, userMapperList, attributeOrPropertyValue, crlCheckingEnabled, crlDPEnabled, cRLRelativePath, oCspCheckingEnabled, ocspResponderUri, ocspResponderCert, keyUsage, extendedKeyUsage, identityConfirmationPageDisallowed);
    }
}

