/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.security.Key;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.util.PemUtils;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.KeysMetadataRepresentation;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class KeyResource {
    private RealmModel realm;
    private KeycloakSession session;
    private AdminPermissionEvaluator auth;

    public KeyResource(RealmModel realm, KeycloakSession session, AdminPermissionEvaluator auth) {
        this.realm = realm;
        this.session = session;
        this.auth = auth;
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public KeysMetadataRepresentation getKeyMetadata() {
        this.auth.realm().requireViewRealm();
        KeysMetadataRepresentation keys = new KeysMetadataRepresentation();
        keys.setKeys(new LinkedList());
        keys.setActive(new HashMap());
        for (KeyWrapper key : this.session.keys().getKeys(this.realm)) {
            KeysMetadataRepresentation.KeyMetadataRepresentation r = new KeysMetadataRepresentation.KeyMetadataRepresentation();
            r.setProviderId(key.getProviderId());
            r.setProviderPriority(key.getProviderPriority());
            r.setKid(key.getKid());
            r.setStatus(key.getStatus() != null ? key.getStatus().name() : null);
            r.setType(key.getType());
            r.setAlgorithm(key.getAlgorithm());
            r.setPublicKey(key.getVerifyKey() != null ? PemUtils.encodeKey((Key)key.getVerifyKey()) : null);
            r.setCertificate(key.getCertificate() != null ? PemUtils.encodeCertificate((Certificate)key.getCertificate()) : null);
            keys.getKeys().add(r);
            if (!key.getStatus().isActive() || keys.getActive().containsKey(key.getAlgorithm())) continue;
            keys.getActive().put(key.getAlgorithm(), key.getKid());
        }
        return keys;
    }
}

