/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.Key;
import java.security.KeyPair;
import java.util.Collections;
import java.util.List;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyStatus;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.AbstractEcdsaKeyProviderFactory;
import org.keycloak.keys.KeyProvider;
import org.keycloak.models.RealmModel;

public abstract class AbstractEcdsaKeyProvider
implements KeyProvider {
    private final KeyStatus status;
    private final ComponentModel model;
    private final KeyWrapper key;

    public AbstractEcdsaKeyProvider(RealmModel realm, ComponentModel model) {
        this.model = model;
        this.status = KeyStatus.from((boolean)model.get("active", true), (boolean)model.get("enabled", true));
        if (model.hasNote(KeyWrapper.class.getName())) {
            this.key = (KeyWrapper)model.getNote(KeyWrapper.class.getName());
        } else {
            this.key = this.loadKey(realm, model);
            model.setNote(KeyWrapper.class.getName(), (Object)this.key);
        }
    }

    protected abstract KeyWrapper loadKey(RealmModel var1, ComponentModel var2);

    public List<KeyWrapper> getKeys() {
        return Collections.singletonList(this.key);
    }

    protected KeyWrapper createKeyWrapper(KeyPair keyPair, String ecInNistRep) {
        KeyWrapper key = new KeyWrapper();
        key.setProviderId(this.model.getId());
        key.setProviderPriority(this.model.get("priority", 0L));
        key.setKid(KeyUtils.createKeyId((Key)keyPair.getPublic()));
        key.setUse(KeyUse.SIG);
        key.setType("EC");
        key.setAlgorithm(AbstractEcdsaKeyProviderFactory.convertECDomainParmNistRepToAlgorithm(ecInNistRep));
        key.setStatus(this.status);
        key.setPrivateKey((Key)keyPair.getPrivate());
        key.setPublicKey((Key)keyPair.getPublic());
        return key;
    }
}

