/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.openshift;

import com.openshift.restclient.ClientBuilder;
import com.openshift.restclient.IClient;
import java.util.List;
import java.util.regex.Pattern;
import org.keycloak.common.Profile;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.CacheableStorageProviderModel;
import org.keycloak.storage.client.ClientStorageProviderFactory;
import org.keycloak.storage.client.ClientStorageProviderModel;
import org.keycloak.storage.openshift.OpenshiftClientStorageProvider;

public class OpenshiftClientStorageProviderFactory
implements ClientStorageProviderFactory<OpenshiftClientStorageProvider>,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "openshift-oauth-client";
    static final Pattern SERVICE_ACCOUNT_PATTERN = Pattern.compile("system:serviceaccount:([^:]+):([^:]+)");
    public static final String CONFIG_PROPERTY_ACCESS_TOKEN = "openshift.access_token";
    public static final String CONFIG_PROPERTY_OPENSHIFT_URI = "openshift.uri";
    public static final String CONFIG_PROPERTY_DEFAULT_NAMESPACE = "openshift.namespace.default";
    public static final String CONFIG_PROPERTY_REQUIRE_USER_CONSENT = "user.consent.require";
    public static final String CONFIG_PROPERTY_DISPLAY_SCOPE_CONSENT_TEXT = "user.consent.scope.consent.text";
    private final List<ProviderConfigProperty> CONFIG_PROPERTIES = ProviderConfigurationBuilder.create().property().name("openshift.access_token").type("String").label("Access Token").helpText("Bearer token that will be used to invoke on Openshift api server.  Must have privilege to lookup oauth clients, service accounts, and invoke on token review interface").add().property().name("openshift.uri").type("String").label("Openshift URL").helpText("Openshift api server URL base endpoint.").add().property().name("openshift.namespace.default").type("String").label("Default Namespace").helpText("The default namespace to use when the server is not able to resolve the namespace from the client identifier. Useful when clients in Openshift don't have names with the following pattern: " + SERVICE_ACCOUNT_PATTERN.pattern()).add().property().name("user.consent.require").type("boolean").defaultValue((Object)"true").label("Require User Consent").helpText("If set to true, clients from this storage will ask the end-user for any scope requested during the authorization flow").add().property().name("user.consent.scope.consent.text").type("boolean").defaultValue((Object)"true").label("Display Scopes Consent Text").helpText("If set to true, the consent page will display texts from the message bundle for scopes. Otherwise, the scope name will be displayed.").add().build();
    private IClient client;

    public String getId() {
        return PROVIDER_ID;
    }

    public OpenshiftClientStorageProvider create(KeycloakSession session, ComponentModel model) {
        ClientStorageProviderModel providerModel = this.createProviderModel(model);
        IClient client = this.getClient(providerModel);
        if (client != null) {
            return new OpenshiftClientStorageProvider(session, providerModel, client);
        }
        client.getAuthorizationContext().setToken(providerModel.get(CONFIG_PROPERTY_ACCESS_TOKEN));
        return new OpenshiftClientStorageProvider(session, providerModel, client);
    }

    public String getHelpText() {
        return "Openshift OAuth Client Adapter";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return this.CONFIG_PROPERTIES;
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        config.getConfig().putSingle((Object)"cachePolicy", (Object)CacheableStorageProviderModel.CachePolicy.NO_CACHE.name());
    }

    public void onUpdate(KeycloakSession session, RealmModel realm, ComponentModel oldModel, ComponentModel newModel) {
        if (!oldModel.get(CONFIG_PROPERTY_OPENSHIFT_URI).equals(newModel.get(CONFIG_PROPERTY_OPENSHIFT_URI))) {
            this.client = null;
        } else {
            this.getClient(this.createProviderModel(newModel)).getAuthorizationContext().setToken(newModel.get(CONFIG_PROPERTY_ACCESS_TOKEN));
        }
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.OPENSHIFT_INTEGRATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IClient getClient(ClientStorageProviderModel providerModel) {
        OpenshiftClientStorageProviderFactory openshiftClientStorageProviderFactory = this;
        synchronized (openshiftClientStorageProviderFactory) {
            if (this.client == null) {
                this.client = new ClientBuilder(providerModel.get(CONFIG_PROPERTY_OPENSHIFT_URI)).build();
            }
        }
        return this.client;
    }

    private ClientStorageProviderModel createProviderModel(ComponentModel model) {
        return new ClientStorageProviderModel(model);
    }
}

