/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.svg;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.util.XMLResourceDescriptor;
import org.jbpm.process.svg.model.Transformation;
import org.jbpm.process.svg.processor.SVGProcessor;
import org.jbpm.process.svg.processor.SVGProcessorFactory;
import org.w3c.dom.Document;

public class SVGImageProcessor {
    private SVGProcessor svgProcessor;

    public SVGImageProcessor(InputStream svg) {
        this(svg, true);
    }

    public SVGImageProcessor(InputStream svg, boolean mapById) {
        try {
            String parser = XMLResourceDescriptor.getXMLParserClassName();
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(parser);
            factory.setValidating(false);
            Document svgDocument = factory.createDocument("http://jbpm.org", svg);
            this.svgProcessor = new SVGProcessorFactory().create(svgDocument, mapById);
            this.svgProcessor.processNodes(svgDocument.getChildNodes());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse svg", e);
        }
    }

    public SVGProcessor getProcessor() {
        return this.svgProcessor;
    }

    public static String transform(InputStream svg, List<String> completed, List<String> active) {
        return SVGImageProcessor.transform(svg, completed, active, null, "#C0C0C0", "#030303", "#FF0000");
    }

    public static String transform(InputStream svg, List<String> completed, List<String> active, Map<String, String> subProcessLinks) {
        return SVGImageProcessor.transform(svg, completed, active, subProcessLinks, "#C0C0C0", "#030303", "#FF0000");
    }

    public static String transform(InputStream svg, List<String> completed, List<String> active, Map<String, String> subProcessLinks, String completedNodeColor, String completedNodeBorderColor, String activeNodeBorderColor) {
        SVGProcessor processor = new SVGImageProcessor(svg).getProcessor();
        for (String string : completed) {
            if (active.contains(string)) continue;
            processor.defaultCompletedTransformation(string, completedNodeColor, completedNodeBorderColor);
        }
        for (String string : active) {
            processor.defaultActiveTransformation(string, activeNodeBorderColor);
        }
        if (subProcessLinks != null) {
            for (Map.Entry entry : subProcessLinks.entrySet()) {
                processor.defaultSubProcessLinkTransformation((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return processor.getSVG();
    }

    public static String transformByName(InputStream svg, List<String> completed, List<String> active) {
        SVGProcessor processor = new SVGImageProcessor(svg, false).getProcessor();
        for (String nodeId : completed) {
            if (active.contains(nodeId)) continue;
            processor.defaultCompletedTransformation(nodeId);
        }
        for (String nodeId : active) {
            processor.defaultActiveTransformation(nodeId);
        }
        return processor.getSVG();
    }

    public void transform(Transformation t) {
        this.getProcessor().transform(t);
    }

    public void defaultCompletedTransformation(String nodeId) {
        this.getProcessor().defaultCompletedTransformation(nodeId);
    }

    public void defaultActiveTransformation(String nodeId) {
        this.getProcessor().defaultActiveTransformation(nodeId);
    }

    public void defaultSubProcessLinkTransformation(String nodeId, String link) {
        this.getProcessor().defaultSubProcessLinkTransformation(nodeId, link);
    }

    public String getSVG() {
        return this.getProcessor().getSVG();
    }
}

