/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriParam;
import org.kie.camel.KieComponent;
import org.kie.camel.KieConfiguration;
import org.kie.camel.KieProducer;
import org.kie.server.client.KieServicesConfiguration;

public class KieEndpoint
extends DefaultEndpoint {
    private final KieServicesConfiguration kieServicesConf;
    private final KieConfiguration configuration;
    @UriParam
    private String username;
    @UriParam
    private String password;
    @UriParam
    private String client;
    @UriParam
    private String operation;

    public KieEndpoint(String uri, KieComponent component, KieServicesConfiguration kieServicesConf, KieConfiguration configuration) throws URISyntaxException, MalformedURLException {
        super(uri, (Component)component);
        this.kieServicesConf = kieServicesConf;
        this.configuration = configuration;
    }

    public KieServicesConfiguration getKieServicesConf() {
        return this.kieServicesConf;
    }

    public KieConfiguration getConfiguration() {
        return this.configuration;
    }

    public Producer createProducer() throws Exception {
        return new KieProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported for " + ((Object)((Object)this)).getClass().getSimpleName() + " endpoint");
    }

    public boolean isSingleton() {
        return true;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }
}

