/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.embedded.dmn;

import java.util.HashMap;
import java.util.Map;
import org.drools.core.runtime.impl.ExecutionResultImpl;
import org.kie.api.KieBase;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieRuntimeFactory;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.internal.command.RegistryContext;

public class DMNEvaluateAllLocalBatchCommand
implements ExecutableCommand<DMNResult> {
    private final String modelNamespace;
    private final String modelName;
    private final Map<String, Object> inputCtx;
    private final String outIdentifier;

    public DMNEvaluateAllLocalBatchCommand(String modelNamespace, String modelName, Map<String, Object> inputCtx, String outIdentifier) {
        this.modelNamespace = modelNamespace;
        this.modelName = modelName;
        this.inputCtx = new HashMap<String, Object>(inputCtx);
        this.outIdentifier = outIdentifier;
    }

    public DMNResult execute(Context context) {
        RegistryContext registryContext = (RegistryContext)context;
        KieBase kBase = (KieBase)registryContext.lookup(KieBase.class);
        DMNRuntime dmnRuntime = (DMNRuntime)KieRuntimeFactory.of((KieBase)kBase).get(DMNRuntime.class);
        DMNModel model = dmnRuntime.getModel(this.modelNamespace, this.modelName);
        DMNContext dmnContext = dmnRuntime.newContext();
        for (Map.Entry<String, Object> kv : this.inputCtx.entrySet()) {
            dmnContext.set(kv.getKey(), kv.getValue());
        }
        DMNResult dmnResult = dmnRuntime.evaluateAll(model, dmnContext);
        registryContext.register(DMNResult.class, (Object)dmnResult);
        if (this.outIdentifier != null) {
            ((ExecutionResultImpl)((RegistryContext)context).lookup(ExecutionResultImpl.class)).setResult(this.outIdentifier, (Object)dmnResult);
        }
        return dmnResult;
    }
}

