/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.net.URL;
import java.util.HashSet;
import org.kie.services.client.api.RemoteRestRuntimeEngineFactory;
import org.kie.services.client.api.builder.RemoteRestRuntimeEngineFactoryBuilder;
import org.kie.services.client.api.builder.exception.InsufficientInfoToBuildException;
import org.kie.services.client.api.command.RemoteConfiguration;

public class RemoteRestRuntimeEngineFactoryBuilderImpl
implements RemoteRestRuntimeEngineFactoryBuilder {
    private RemoteConfiguration config = new RemoteConfiguration(RemoteConfiguration.Type.REST);
    private String username;
    private String password;
    private URL url;

    RemoteRestRuntimeEngineFactoryBuilderImpl() {
    }

    @Override
    public RemoteRestRuntimeEngineFactoryBuilder addDeploymentId(String deploymentId) {
        this.config.setDeploymentId(deploymentId);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineFactoryBuilder addProcessInstanceId(long processInstanceId) {
        this.config.setProcessInstanceId(processInstanceId);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineFactoryBuilder addUserName(String userName) {
        this.username = userName;
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineFactoryBuilder addPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineFactoryBuilder addUrl(URL url) {
        this.url = url;
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineFactoryBuilder addTimeout(int timeoutInSeconds) {
        this.config.setTimeout(timeoutInSeconds);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineFactoryBuilder addExtraJaxbClasses(Class ... classes) {
        HashSet classSet = new HashSet();
        for (Class clazz : classes) {
            classSet.add(clazz);
        }
        this.config.addJaxbClasses(classSet);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineFactoryBuilder clearJaxbClasses() {
        this.config.clearJaxbClasses();
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineFactoryBuilder useFormBasedAuth(boolean formBasedAuth) {
        this.config.setUseFormBasedAuth(formBasedAuth);
        return this;
    }

    @Override
    public RemoteRestRuntimeEngineFactory build() throws InsufficientInfoToBuildException {
        if (this.url == null) {
            throw new InsufficientInfoToBuildException("A URL is required to build the factory.");
        }
        if (this.username == null) {
            throw new InsufficientInfoToBuildException("A user name is required to build the factory.");
        }
        if (this.password == null) {
            throw new InsufficientInfoToBuildException("A password is required to build the factory.");
        }
        this.config.createRequestFactory(this.url, this.username, this.password);
        return new RemoteRestRuntimeEngineFactory(this.config.clone());
    }

    public static RemoteRestRuntimeEngineFactoryBuilderImpl newBuilder() {
        return new RemoteRestRuntimeEngineFactoryBuilderImpl();
    }
}

