/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.kopitubruk.util.json.BadPropertyNameException;
import org.kopitubruk.util.json.DataStructureLoopDetector;
import org.kopitubruk.util.json.DuplicatePropertyNameException;
import org.kopitubruk.util.json.FixedPseudoMap;
import org.kopitubruk.util.json.IndentPadding;
import org.kopitubruk.util.json.JSONAble;
import org.kopitubruk.util.json.JSONArrayData;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONType;
import org.kopitubruk.util.json.ReflectedObjectMapBuilder;
import org.kopitubruk.util.json.StringProcessor;
import org.kopitubruk.util.json.StringWriter;

public class JSONUtil {
    private static final Pattern JSON_NUMBER_PAT = Pattern.compile("^-?(?:(?:\\d+(?:\\.\\d+)?)|(?:\\.\\d+))(?:[eE][-+]?\\d+)?$");
    private static final Pattern OCTAL_NUMBER_PAT = Pattern.compile("^-?0[0-7]+$");
    private static final Pattern VALID_ECMA5_PROPERTY_NAME_PAT = Pattern.compile("^(?:[_\\$\\p{L}]|\\\\u\\p{XDigit}{4})(?:[_\\$\\p{L}\\p{Nd}\\p{Mn}\\p{Mc}\\p{Pc}\\u200C\\u200D]|\\\\u\\p{XDigit}{4})*$");
    static final Pattern VALID_ECMA6_PROPERTY_NAME_PAT = Pattern.compile("^(?:[_\\$\\p{L}\\p{Nl}]|\\\\u\\p{XDigit}{4}|\\\\u\\{\\p{XDigit}+\\})(?:[_\\$\\p{L}\\p{Nl}\\p{Nd}\\p{Mn}\\p{Mc}\\p{Pc}\\u200C\\u200D]|\\\\u\\p{XDigit}{4}|\\\\u\\{\\p{XDigit}+\\})*$");
    private static final Pattern VALID_JSON5_PROPERTY_NAME_PAT = Pattern.compile("^([^\u0000-\u001f\\p{Cn}\"/\\\\]|\\\\[bfnrt\\\\/\"]|\\\\u\\p{XDigit}{4})+$");
    private static final Pattern VALID_JSON6_PROPERTY_NAME_PAT = Pattern.compile("^([^\u0000-\u001f\\p{Cn}\"/\\\\]|\\\\[bfnrt\\\\/\"]|\\\\u\\p{XDigit}{4}|\\\\u\\{\\p{XDigit}+\\})+$");
    private static final Set<String> RESERVED_WORDS = new HashSet<String>(Arrays.asList("break", "case", "catch", "continue", "debugger", "default", "delete", "do", "else", "finally", "for", "function", "if", "in", "instanceof", "new", "return", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "class", "const", "enum", "export", "extends", "implements", "import", "interface", "let", "package", "private", "protected", "public", "static", "super", "yield", "await", "true", "false", "null", "undefined", "Infinity", "NaN"));

    public static String toJSON(Object obj) {
        return JSONUtil.toJSON(obj, (JSONConfig)null);
    }

    public static String toJSON(Object obj, JSONConfig cfg) {
        StringWriter json = new StringWriter();
        try {
            JSONUtil.toJSON(obj, cfg, json);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ((Object)json).toString();
    }

    public static void toJSON(Object obj, Writer json) throws IOException {
        JSONUtil.toJSON(obj, null, json);
    }

    public static void toJSON(Object obj, JSONConfig cfg, Writer json) throws IOException {
        JSONConfig jcfg = cfg == null ? new JSONConfig() : cfg;
        try {
            JSONUtil.appendPropertyValue(obj, json, jcfg);
        }
        catch (Throwable e) {
            jcfg.clearObjStack();
            IndentPadding.reset(jcfg);
            throw e;
        }
    }

    private static void appendPropertyValue(Object propertyValue, Writer json, JSONConfig cfg) throws IOException {
        if (propertyValue == null) {
            json.write("null");
        } else {
            JSONType jsonType = new JSONType(propertyValue, cfg);
            if (jsonType.isRecursible()) {
                JSONUtil.appendRecursiblePropertyValue(propertyValue, json, cfg, jsonType);
            } else {
                JSONUtil.appendSimplePropertyValue(propertyValue, json, cfg, jsonType);
            }
        }
    }

    private static void appendRecursiblePropertyValue(Object propertyValue, Writer json, JSONConfig cfg, JSONType jsonType) throws IOException {
        DataStructureLoopDetector loopDetector = null;
        boolean detectDataStructureLoops = cfg.isDetectDataStructureLoops();
        if (detectDataStructureLoops) {
            loopDetector = new DataStructureLoopDetector(cfg, propertyValue);
        }
        if (jsonType.isJSONAble()) {
            JSONAble jsonAble = (JSONAble)propertyValue;
            jsonAble.toJSON(cfg, json);
        } else if (jsonType.isArrayType()) {
            JSONUtil.appendArrayPropertyValue(propertyValue, json, cfg);
        } else {
            Map<Object, Object> map = null;
            if (jsonType.isResourceBundle()) {
                ResourceBundle bundle = (ResourceBundle)propertyValue;
                map = JSONUtil.resourceBundleToMap(bundle);
            } else if (jsonType.isMapType()) {
                map = (Map<Object, Object>)propertyValue;
            } else if (jsonType.isReflectType()) {
                ReflectedObjectMapBuilder builder = new ReflectedObjectMapBuilder(propertyValue, cfg);
                builder.init();
                map = builder.buildReflectedObjectMap();
            }
            JSONUtil.appendObjectPropertyValue(map, json, cfg);
        }
        if (detectDataStructureLoops) {
            loopDetector.popDataStructureStack();
        }
    }

    private static void appendSimplePropertyValue(Object propertyValue, Writer json, JSONConfig cfg, JSONType jsonType) throws IOException {
        if (propertyValue instanceof Number) {
            JSONUtil.appendNumber((Number)propertyValue, json, cfg);
        } else if (propertyValue instanceof Boolean) {
            json.write(propertyValue.toString());
        } else if (propertyValue instanceof Date && cfg.isFormatDates()) {
            JSONUtil.appendDate((Date)propertyValue, json, cfg);
        } else if (propertyValue instanceof CharSequence || propertyValue instanceof Character || propertyValue.getClass().isEnum() || !cfg.isReflectUnknownObjects()) {
            boolean checkNum = true;
            JSONUtil.writeString(propertyValue.toString(), json, cfg, checkNum);
        } else {
            jsonType.forceReflectType();
            JSONUtil.appendRecursiblePropertyValue(propertyValue, json, cfg, jsonType);
        }
    }

    private static void appendNumber(Number num, Writer json, JSONConfig cfg) throws IOException {
        NumberFormat fmt = cfg.getNumberFormat(num);
        if (fmt == null) {
            String numericString = num.toString();
            if (JSONUtil.isSafeJsonNumber(num, null, cfg)) {
                json.write(numericString);
            } else {
                JSONUtil.fastWriteString(numericString, json);
            }
        } else {
            String numericString = fmt.format(num, new StringBuffer(), new FieldPosition(0)).toString();
            if (JSONUtil.isValidJSONNumber(numericString, cfg, num)) {
                json.write(numericString);
            } else {
                boolean checkNum = false;
                JSONUtil.writeString(numericString, json, cfg, checkNum);
            }
        }
    }

    private static void appendDate(Date date, Writer json, JSONConfig cfg) throws IOException {
        if (cfg.isEncodeDatesAsObjects()) {
            json.write("new Date(");
        }
        boolean checkNum = false;
        JSONUtil.writeString(cfg.getDateGenFormat().format(date), json, cfg, checkNum);
        if (cfg.isEncodeDatesAsObjects()) {
            json.write(41);
        }
    }

    private static void appendArrayPropertyValue(Object propertyValue, Writer json, JSONConfig cfg) throws IOException {
        boolean didStart = false;
        json.write(91);
        IndentPadding.incPadding(cfg);
        for (Object value : new JSONArrayData(propertyValue)) {
            if (didStart) {
                json.write(44);
            } else {
                didStart = true;
            }
            IndentPadding.appendPadding(cfg, json);
            JSONUtil.appendPropertyValue(value, json, cfg);
        }
        IndentPadding.decAppendPadding(cfg, json);
        json.write(93);
    }

    private static void appendObjectPropertyValue(Map<?, ?> map, Writer json, JSONConfig cfg) throws IOException {
        HashSet<String> propertyNames = cfg.isValidatePropertyNames() ? new HashSet<String>(map.size()) : null;
        boolean didStart = false;
        boolean quoteIdentifier = cfg.isQuoteIdentifier();
        boolean havePadding = cfg.getIndentPadding() != null;
        json.write(123);
        IndentPadding.incPadding(cfg);
        for (Map.Entry<?, ?> property : map.entrySet()) {
            boolean extraIndent;
            String propertyName = JSONUtil.getPropertyName(property.getKey(), cfg, propertyNames);
            Object value = property.getValue();
            boolean bl = extraIndent = havePadding && value != null && new JSONType(value, cfg).isRecursible();
            if (didStart) {
                json.write(44);
            } else {
                didStart = true;
            }
            IndentPadding.appendPadding(cfg, json);
            JSONUtil.appendPropertyName(propertyName, json, quoteIdentifier);
            IndentPadding.incAppendPadding(cfg, json, extraIndent);
            JSONUtil.appendPropertyValue(value, json, cfg);
            IndentPadding.decAppendPadding(cfg, json, extraIndent);
        }
        IndentPadding.decAppendPadding(cfg, json);
        json.write(125);
    }

    private static Map<?, ?> resourceBundleToMap(ResourceBundle bundle) {
        Set<String> keySet = bundle.keySet();
        FixedPseudoMap result = new FixedPseudoMap(keySet.size());
        for (String key : keySet) {
            result.put(key, bundle.getObject(key));
        }
        return result;
    }

    private static String getPropertyName(Object key, JSONConfig cfg, Set<String> propertyNames) {
        String propertyName;
        String string = propertyName = key == null ? null : key.toString();
        if (propertyName == null || propertyName.length() < 1) {
            throw new BadPropertyNameException(propertyName, cfg);
        }
        if (cfg.isEscapeBadIdentifierCodePoints()) {
            propertyName = JSONUtil.escapeBadIdentifierCodePoints(propertyName, cfg);
        } else if (cfg.isEscapeNonAscii()) {
            propertyName = JSONUtil.escapeNonAscii(propertyName, cfg);
        } else if (cfg.isEscapeSurrogates()) {
            propertyName = JSONUtil.escapeSurrogates(propertyName, cfg);
        }
        if (cfg.isValidatePropertyNames()) {
            if (propertyNames.contains(propertyName)) {
                throw new DuplicatePropertyNameException(propertyName, cfg);
            }
            JSONUtil.checkValidJavascriptPropertyNameImpl(propertyName, cfg);
            propertyNames.add(propertyName);
        }
        return propertyName;
    }

    private static void appendPropertyName(String propertyName, Writer json, boolean quoteIdentifier) throws IOException {
        boolean doQuote;
        boolean bl = doQuote = quoteIdentifier || JSONUtil.isReservedWord(propertyName) || JSONUtil.hasSurrogates(propertyName);
        if (doQuote) {
            JSONUtil.fastWriteString(propertyName, json);
        } else {
            json.write(propertyName);
        }
        json.write(58);
    }

    private static String escapeBadIdentifierCodePoints(String propertyName, JSONConfig cfg) {
        boolean processInlineEscapes;
        boolean useSingleLetterEscapes = cfg.isFullJSONIdentifierCodePoints();
        StringProcessor cp = new StringProcessor(propertyName, cfg, useSingleLetterEscapes, processInlineEscapes = true);
        if (cp.isNoProcessing() && JSONUtil.isValidJavascriptPropertyNameImpl(propertyName, cfg)) {
            return propertyName;
        }
        StringBuilder buf = new StringBuilder(propertyName.length() + 20);
        while (cp.nextReady()) {
            String esc = cp.getEscape();
            if (esc != null) {
                buf.append(esc);
                continue;
            }
            if (cp.getIndex() > 0 && JSONUtil.isValidIdentifierPart(cp.getCodePoint(), cfg)) {
                cp.appendChars(buf);
                continue;
            }
            if (cp.getIndex() == 0 && JSONUtil.isValidIdentifierStart(cp.getCodePoint(), cfg)) {
                cp.appendChars(buf);
                continue;
            }
            buf.append(cp.getEscapeString());
        }
        return buf.toString();
    }

    private static String escapeNonAscii(String str, JSONConfig cfg) {
        boolean noNonAscii = true;
        int len = str.length();
        for (int i = 0; noNonAscii && i < len; ++i) {
            noNonAscii = str.charAt(i) <= '\u007f';
        }
        if (noNonAscii) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str.length() + 20);
        StringProcessor cp = new StringProcessor(str, cfg);
        while (cp.nextReady()) {
            if (cp.getCodePoint() > 127) {
                buf.append(cp.getEscapeString());
                continue;
            }
            cp.appendChars(buf);
        }
        return buf.toString();
    }

    private static String escapeSurrogates(String str, JSONConfig cfg) {
        if (JSONUtil.hasSurrogates(str)) {
            StringBuilder buf = new StringBuilder(str.length());
            StringProcessor cp = new StringProcessor(str, cfg);
            while (cp.nextReady()) {
                if (cp.getCharCount() > 1) {
                    buf.append(cp.getEscapeString());
                    continue;
                }
                cp.appendChars(buf);
            }
            return buf.toString();
        }
        return str;
    }

    private static boolean hasSurrogates(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (!Character.isSurrogate(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static void writeString(String strValue, Writer json, JSONConfig cfg, boolean checkNum) throws IOException {
        if (checkNum && cfg.isEncodeNumericStringsAsNumbers() && JSONUtil.isValidJSONNumber(strValue, cfg, null)) {
            json.write(strValue);
        } else if (cfg.isFastStrings()) {
            JSONUtil.fastWriteString(strValue, json);
        } else {
            if (cfg.isUnEscapeWherePossible()) {
                strValue = StringProcessor.unEscape(strValue, cfg);
            }
            json.write(34);
            new StringProcessor(strValue, cfg, cfg.isPassThroughEscapes()).writeString(json);
            json.write(34);
        }
    }

    private static void fastWriteString(String strValue, Writer json) throws IOException {
        json.write(34);
        json.write(strValue);
        json.write(34);
    }

    private static boolean isValidJSONNumber(String numericString, JSONConfig cfg, Number num) {
        return JSON_NUMBER_PAT.matcher(numericString).matches() && !OCTAL_NUMBER_PAT.matcher(numericString).matches() && JSONUtil.isSafeJsonNumber(num, numericString, cfg);
    }

    private static boolean isSafeJsonNumber(Number num, String numericString, JSONConfig cfg) {
        boolean isSafeJsonNumber = true;
        if (num == null) {
            num = new BigDecimal(numericString);
        }
        if (!(num instanceof Integer)) {
            if (num instanceof Double) {
                Double d = (Double)num;
                isSafeJsonNumber = !d.isInfinite() && !d.isNaN();
            } else if (num instanceof Long) {
                if (cfg.isPreciseNumbers()) {
                    double d;
                    long y;
                    long x = (Long)num;
                    isSafeJsonNumber = x == (y = (long)(d = (double)x));
                }
            } else if (num instanceof Float) {
                Float f = (Float)num;
                isSafeJsonNumber = !f.isInfinite() && !f.isNaN();
            } else {
                boolean isBigDecimal = num instanceof BigDecimal;
                if (isBigDecimal || num instanceof BigInteger) {
                    Double d = num.doubleValue();
                    boolean bl = isSafeJsonNumber = !d.isInfinite() && !d.isNaN();
                    if (isSafeJsonNumber && cfg.isPreciseNumbers()) {
                        BigDecimal bigDec = isBigDecimal ? (BigDecimal)num : new BigDecimal((BigInteger)num);
                        isSafeJsonNumber = bigDec.compareTo(new BigDecimal(d.toString())) == 0;
                    }
                }
            }
        }
        return isSafeJsonNumber;
    }

    static ResourceBundle getBundle(Locale locale) {
        String bundleName = JSONUtil.class.getPackage().getName() + ".JSON";
        return ResourceBundle.getBundle(bundleName, locale);
    }

    public static Set<String> getJavascriptReservedWords() {
        return new TreeSet<String>(RESERVED_WORDS);
    }

    public static boolean isReservedWord(String name) {
        return RESERVED_WORDS.contains(name);
    }

    static boolean isValidIdentifierStart(int codePoint, JSONConfig cfg) {
        if (cfg.isFullJSONIdentifierCodePoints()) {
            return JSONUtil.isValidIdentifierPart(codePoint, cfg);
        }
        return codePoint == 95 || codePoint == 36 || (cfg.isUseECMA6() ? Character.isUnicodeIdentifierStart(codePoint) : Character.isLetter(codePoint));
    }

    static boolean isValidIdentifierPart(int codePoint, JSONConfig cfg) {
        if (cfg.isFullJSONIdentifierCodePoints()) {
            return codePoint >= 32 && Character.isDefined(codePoint) && (codePoint > 92 || !StringProcessor.haveJsonEsc((char)codePoint));
        }
        return cfg.isUseECMA6() ? Character.isUnicodeIdentifierPart(codePoint) : JSONUtil.isValidIdentifierStart(codePoint, cfg) || Character.isDigit(codePoint) || (8388928 >> Character.getType(codePoint) & 1) != 0 || codePoint == 8204 || codePoint == 8205;
    }

    public static void checkValidJavascriptPropertyName(String propertyName, JSONConfig cfg) throws BadPropertyNameException {
        JSONConfig jcfg = cfg != null ? cfg : new JSONConfig();
        JSONUtil.checkValidJavascriptPropertyNameImpl(propertyName, jcfg);
    }

    public static void checkValidJavascriptPropertyName(String propertyName) throws BadPropertyNameException {
        JSONUtil.checkValidJavascriptPropertyNameImpl(propertyName, new JSONConfig());
    }

    private static void checkValidJavascriptPropertyNameImpl(String propertyName, JSONConfig cfg) throws BadPropertyNameException {
        if (!JSONUtil.isValidJavascriptPropertyNameImpl(propertyName, cfg)) {
            throw new BadPropertyNameException(propertyName, cfg);
        }
    }

    public static boolean isValidJavascriptPropertyName(String propertyName, JSONConfig cfg) {
        JSONConfig jcfg = cfg != null ? cfg : new JSONConfig();
        return JSONUtil.isValidJavascriptPropertyNameImpl(propertyName, jcfg);
    }

    public static boolean isValidJavascriptPropertyName(String propertyName) {
        return JSONUtil.isValidJavascriptPropertyNameImpl(propertyName, new JSONConfig());
    }

    private static boolean isValidJavascriptPropertyNameImpl(String propertyName, JSONConfig cfg) {
        return propertyName != null && (!JSONUtil.isReservedWord(propertyName) || cfg.isAllowReservedWordsInIdentifiers()) && cfg.getPropertyNameValidationPattern().matcher(propertyName).matches();
    }

    static Pattern getPropertyNameValidationPattern(JSONConfig cfg) {
        Pattern validationPat = cfg.isFullJSONIdentifierCodePoints() ? (cfg.isUseECMA6() ? VALID_JSON6_PROPERTY_NAME_PAT : VALID_JSON5_PROPERTY_NAME_PAT) : (cfg.isUseECMA6() ? VALID_ECMA6_PROPERTY_NAME_PAT : VALID_ECMA5_PROPERTY_NAME_PAT);
        return validationPat;
    }

    private JSONUtil() {
    }
}

