/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.client;

import java.io.IOException;
import org.kurento.jsonrpc.Session;
import org.kurento.jsonrpc.Transaction;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.kurento.jsonrpc.message.ResponseError;

public abstract class AbstractTransaction
implements Transaction {
    protected final Session session;
    protected boolean async;
    protected final Request<?> request;

    public AbstractTransaction(Session session, Request<?> request) {
        this.session = session;
        this.request = request;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void startAsync() {
        this.async = true;
    }

    public boolean isAsync() {
        return this.async;
    }

    @Override
    public void sendResponse(Object result) throws IOException {
        this.internalSendResponse(new Response<Object>(this.request.getId(), result));
    }

    @Override
    public void sendError(int code, String message, String data) throws IOException {
        this.internalSendResponse(new Response(this.request.getId(), new ResponseError(code, message, data)));
    }

    @Override
    public void sendError(Throwable e) throws IOException {
        ResponseError error = ResponseError.newFromException(e);
        this.internalSendResponse(new Response(this.request.getId(), error));
    }

    @Override
    public void sendVoidResponse() throws IOException {
        this.sendResponse(null);
    }

    @Override
    public void sendError(ResponseError error) throws IOException {
        this.internalSendResponse(new Response(this.request.getId(), error));
    }

    @Override
    public void sendResponseObject(Response<? extends Object> response) throws IOException {
        this.internalSendResponse(response);
    }

    @Override
    public boolean isNotification() {
        return this.request.getId() == null;
    }

    protected abstract void internalSendResponse(Response<? extends Object> var1) throws IOException;
}

