/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.server.config;

import com.google.common.base.Strings;
import com.woorea.openstack.keystone.Keystone;
import com.woorea.openstack.keystone.model.Access;
import com.woorea.openstack.keystone.model.Authentication;
import com.woorea.openstack.keystone.model.authentication.UsernamePassword;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.kurento.jsonrpc.internal.server.config.JsonRpcProperties;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Verb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.filter.OncePerRequestFilter;

public class OAuthFiWareFilter
extends OncePerRequestFilter {
    private static final String X_AUTH_HEADER = "X-Auth-Token";
    private static final Logger log = LoggerFactory.getLogger(OAuthFiWareFilter.class);
    @Autowired
    private JsonRpcProperties props;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String fullUrl = request.getRequestURL().append('?').append(request.getQueryString()).toString();
        log.trace("Client trying to stablish new websocket session with {}", (Object)fullUrl);
        if (!Strings.isNullOrEmpty((String)this.props.getKeystoneHost())) {
            String accessToken = this.parseAccessToken(request);
            if (Strings.isNullOrEmpty((String)accessToken)) {
                log.warn("Request from {} without OAuth token", (Object)request.getRemoteAddr());
                response.sendError(401, "Access token not found in request");
            } else if (this.isTokenValid(accessToken)) {
                log.trace("The request from {} was authorized", (Object)request.getRemoteAddr());
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                response.sendError(401, "Unathorized request");
            }
        } else {
            log.trace("Request from {} authorized: no keystone host configured", (Object)request.getRemoteAddr());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean isTokenValid(String accessToken) {
        Response oauthResp = this.validateTokenWithServer(accessToken);
        if (!oauthResp.isSuccessful() && oauthResp.getCode() == 401) {
            this.props.setAuthToken(this.obtainFilterToken());
            oauthResp = this.validateTokenWithServer(accessToken);
        }
        if (!oauthResp.isSuccessful()) {
            String msg = "OAuth server returns error code: " + oauthResp.getCode() + " and message '" + oauthResp.getMessage() + '\'';
            log.warn("There was a request with a unauthorized OAuth token. {}", (Object)msg);
        }
        return oauthResp.isSuccessful();
    }

    private Response validateTokenWithServer(String accessToken) {
        String authToken = this.props.getAuthToken();
        String url = this.props.getKeystoneHost() + ':' + this.props.getKeystonePort() + this.props.getKeystonePath() + accessToken;
        OAuthRequest oauthReq = new OAuthRequest(Verb.GET, url);
        oauthReq.addHeader(X_AUTH_HEADER, authToken);
        return oauthReq.send();
    }

    private String obtainFilterToken() {
        Keystone keystone = new Keystone(this.props.getKeystoneHost() + ':' + this.props.getKeystonePort() + '/' + this.props.getOAuthVersion());
        UsernamePassword authentication = new UsernamePassword(this.props.getKeystoneProxyUser(), this.props.getKeystoneProxyPass());
        Access access = (Access)keystone.tokens().authenticate((Authentication)authentication).execute();
        return access.getToken().getId();
    }

    private String parseAccessToken(HttpServletRequest request) {
        String accessToken = request.getHeader(X_AUTH_HEADER);
        if (accessToken == null) {
            accessToken = request.getParameter("access_token");
        }
        return accessToken;
    }
}

