/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.ws;

import java.io.IOException;
import org.kurento.jsonrpc.internal.client.AbstractSession;
import org.kurento.jsonrpc.internal.client.TransactionImpl;
import org.kurento.jsonrpc.internal.server.ProtocolManager;
import org.kurento.jsonrpc.internal.server.ServerSession;
import org.kurento.jsonrpc.internal.server.SessionsManager;
import org.kurento.jsonrpc.internal.ws.CloseStatusHelper;
import org.kurento.jsonrpc.internal.ws.WebSocketServerSession;
import org.kurento.jsonrpc.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class JsonRpcWebSocketHandler
extends TextWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(JsonRpcWebSocketHandler.class);
    private final ProtocolManager protocolManager;
    private String label = "";

    public JsonRpcWebSocketHandler(ProtocolManager protocolManager) {
        this.protocolManager = protocolManager;
    }

    public void setLabel(String label) {
        this.label = "[" + label + "] ";
        this.protocolManager.setLabel(label);
    }

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        try {
            log.info("{} Client connection stablished from session={} uri={} headers={} acceptedProtocol={} attributes={}", new Object[]{this.label, session.getRemoteAddress(), session.getUri(), session.getHandshakeHeaders(), session.getAcceptedProtocol(), session.getAttributes()});
        }
        catch (Throwable t) {
            log.error(this.label + "Exception processing afterConnectionEstablished in session={}", (Object)session.getId(), (Object)t);
        }
    }

    public void afterConnectionClosed(WebSocketSession wsSession, CloseStatus status) throws Exception {
        try {
            AbstractSession session = this.protocolManager.getSessionByTransportId(wsSession.getId());
            if (session != null) {
                log.info("{} WebSocket session {} with transportId {} closed for {} (code {}, reason '{}')", new Object[]{this.label, session.getSessionId(), wsSession.getId(), CloseStatusHelper.getCloseStatusType(status.getCode()), status.getCode(), status.getReason()});
                this.protocolManager.closeSessionIfTimeout(wsSession.getId(), status.getReason());
            } else {
                log.info("{} WebSocket session not associated to any jsonRpcSession with transportId {} closed for {} (code {}, reason '{}')", new Object[]{this.label, wsSession.getId(), CloseStatusHelper.getCloseStatusType(status.getCode()), status.getCode(), status.getReason()});
            }
        }
        catch (Throwable t) {
            log.error(this.label + "Exception processing afterConnectionClosed in session={}", (Object)wsSession.getId(), (Object)t);
        }
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        try {
            this.protocolManager.processTransportError(session.getId(), exception);
        }
        catch (Throwable t) {
            log.error(this.label + "Exception processing transportError in session={}", (Object)session.getId(), (Object)t);
        }
    }

    public void handleTextMessage(final WebSocketSession wsSession, TextMessage message) throws Exception {
        try {
            String messageJson = (String)message.getPayload();
            ProtocolManager.ServerSessionFactory factory = new ProtocolManager.ServerSessionFactory(){

                @Override
                public ServerSession createSession(String sessionId, Object registerInfo, SessionsManager sessionsManager) {
                    return new WebSocketServerSession(sessionId, registerInfo, sessionsManager, wsSession);
                }

                @Override
                public void updateSessionOnReconnection(ServerSession session) {
                    ((WebSocketServerSession)session).updateWebSocketSession(wsSession);
                }
            };
            this.protocolManager.processMessage(messageJson, factory, new TransactionImpl.ResponseSender(){

                public void sendResponse(Message message) throws IOException {
                    String jsonMessage = message.toString();
                    log.debug("{} <-Res {}", (Object)JsonRpcWebSocketHandler.this.label, (Object)jsonMessage);
                    this.sendJsonMessage(jsonMessage);
                }

                public void sendPingResponse(Message message) throws IOException {
                    String jsonMessage = message.toString();
                    log.trace("{} <-Res {}", (Object)JsonRpcWebSocketHandler.this.label, (Object)jsonMessage);
                    this.sendJsonMessage(jsonMessage);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void sendJsonMessage(String jsonMessage) throws IOException {
                    WebSocketSession webSocketSession = wsSession;
                    synchronized (webSocketSession) {
                        if (wsSession.isOpen()) {
                            wsSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)jsonMessage));
                        } else {
                            log.error("Trying to send a message to a closed session");
                        }
                    }
                }
            }, wsSession.getId());
        }
        catch (Throwable t) {
            log.error(this.label + "Exception processing request", t);
        }
    }
}

