/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.server;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.PostConstruct;
import org.kurento.commons.SecretGenerator;
import org.kurento.jsonrpc.JsonRpcHandler;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.Session;
import org.kurento.jsonrpc.internal.JsonRpcHandlerManager;
import org.kurento.jsonrpc.internal.client.AbstractSession;
import org.kurento.jsonrpc.internal.client.TransactionImpl;
import org.kurento.jsonrpc.internal.server.NativeSessionHandler;
import org.kurento.jsonrpc.internal.server.PingWatchdogManager;
import org.kurento.jsonrpc.internal.server.ServerSession;
import org.kurento.jsonrpc.internal.server.SessionsManager;
import org.kurento.jsonrpc.message.Message;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.kurento.jsonrpc.message.ResponseError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskRejectedException;
import org.springframework.scheduling.TaskScheduler;

public class ProtocolManager {
    public static final String CLIENT_CLOSED_CLOSE_REASON = "Client sent close message";
    private static final String INTERVAL_PROPERTY = "interval";
    private static final Logger log = LoggerFactory.getLogger(ProtocolManager.class);
    private static final SimpleDateFormat format = new SimpleDateFormat("MM-dd-yyyy hh:mm:ss,S");
    protected SecretGenerator secretGenerator = new SecretGenerator();
    @Autowired
    private SessionsManager sessionsManager;
    @Autowired
    @Qualifier(value="jsonrpcTaskScheduler")
    private TaskScheduler taskScheduler;
    private final JsonRpcHandlerManager handlerManager;
    private String label = "";
    private int maxHeartbeats = 0;
    private int heartbeats = 0;
    private PingWatchdogManager pingWachdogManager;

    public ProtocolManager(JsonRpcHandler<?> handler) {
        this.handlerManager = new JsonRpcHandlerManager(handler);
    }

    public ProtocolManager(JsonRpcHandler<?> handler, SessionsManager sessionsManager, TaskScheduler taskScheduler) {
        this.handlerManager = new JsonRpcHandlerManager(handler);
        this.sessionsManager = sessionsManager;
        this.taskScheduler = taskScheduler;
        this.postConstruct();
    }

    @PostConstruct
    private void postConstruct() {
        PingWatchdogManager.NativeSessionCloser nativeSessionCloser = new PingWatchdogManager.NativeSessionCloser(){

            @Override
            public void closeSession(String transportId) {
                ServerSession serverSession = ProtocolManager.this.sessionsManager.getByTransportId(transportId);
                if (serverSession != null) {
                    serverSession.closeNativeSession("Close for not receive ping from client");
                } else {
                    log.warn("Ping wachdog trying to close a non-registered ServerSession");
                }
            }
        };
        this.pingWachdogManager = new PingWatchdogManager(this.taskScheduler, nativeSessionCloser);
    }

    public void setLabel(String label) {
        this.label = "[" + label + "] ";
    }

    public void processMessage(String messageJson, ServerSessionFactory factory, TransactionImpl.ResponseSender responseSender, String internalSessionId) throws IOException {
        JsonObject messagetJsonObject = (JsonObject)JsonUtils.fromJson((String)messageJson, JsonObject.class);
        this.processMessage(messagetJsonObject, factory, responseSender, internalSessionId);
    }

    public void processMessage(JsonObject messagetJsonObject, ServerSessionFactory factory, TransactionImpl.ResponseSender responseSender, String internalSessionId) throws IOException {
        if (messagetJsonObject.has("method")) {
            this.processRequestMessage(factory, messagetJsonObject, responseSender, internalSessionId);
        } else {
            this.processResponseMessage(messagetJsonObject, internalSessionId);
        }
    }

    private void processRequestMessage(ServerSessionFactory factory, JsonObject requestJsonObject, final TransactionImpl.ResponseSender responseSender, String transportId) throws IOException {
        final Request request = JsonUtils.fromJsonRequest((JsonObject)requestJsonObject, JsonElement.class);
        switch (request.getMethod()) {
            case "connect": {
                log.debug("{} Req-> {} (transportId={})", new Object[]{this.label, request, transportId});
                this.processReconnectMessage(factory, (Request<JsonElement>)request, responseSender, transportId);
                break;
            }
            case "ping": {
                log.trace("{} Req-> {} (transportId={})", new Object[]{this.label, request, transportId});
                this.processPingMessage(factory, (Request<JsonElement>)request, responseSender, transportId);
                break;
            }
            case "closeSession": {
                log.trace("{} Req-> {} (transportId={})", new Object[]{this.label, request, transportId});
                this.processCloseMessage(factory, (Request<JsonElement>)request, responseSender, transportId);
                break;
            }
            default: {
                final ServerSession session = this.getOrCreateSession(factory, transportId, (Request<JsonElement>)request);
                log.debug("{} Req-> {} [jsonRpcSessionId={}, transportId={}]", new Object[]{this.label, request, session.getSessionId(), transportId});
                if (request.getMethod().equals("poll")) {
                    Type collectionType = new TypeToken<List<Response<JsonElement>>>(){}.getType();
                    List responseList = (List)JsonUtils.fromJson((JsonElement)((JsonElement)request.getParams()), (Type)collectionType);
                    for (Response response : responseList) {
                        session.handleResponse((Response<JsonElement>)response);
                    }
                    responseSender.sendResponse((Message)new Response(request.getId(), Collections.emptyList()));
                    break;
                }
                session.processRequest(new Runnable(){

                    @Override
                    public void run() {
                        ProtocolManager.this.handlerManager.handleRequest((Session)session, request, responseSender);
                    }
                });
            }
        }
    }

    private ServerSession getOrCreateSession(ServerSessionFactory factory, String transportId, Request<JsonElement> request) {
        ServerSession session = null;
        String reqSessionId = request.getSessionId();
        if (reqSessionId != null) {
            session = this.sessionsManager.get(reqSessionId);
            if (session == null && (session = this.createSessionAsOldIfKnowByHandler(factory, reqSessionId)) == null) {
                log.warn(this.label + "There is no session with specified id '{}'." + "Creating a new one.", (Object)reqSessionId);
            }
        } else if (transportId != null) {
            session = this.sessionsManager.getByTransportId(transportId);
        }
        if (session == null) {
            session = this.createSession(factory, null);
            this.handlerManager.afterConnectionEstablished((Session)session);
        } else {
            session.setNew(false);
        }
        return session;
    }

    private ServerSession createSessionAsOldIfKnowByHandler(ServerSessionFactory factory, String reqSessionId) {
        NativeSessionHandler nativeHandler;
        ServerSession session = null;
        JsonRpcHandler handler = this.handlerManager.getHandler();
        if (handler instanceof NativeSessionHandler && (nativeHandler = (NativeSessionHandler)handler).isSessionKnown(reqSessionId)) {
            log.debug("Session {} is already known by NativeSessionHandler", (Object)reqSessionId);
            session = this.createSession(factory, null, reqSessionId);
            session.setNew(false);
            nativeHandler.processNewCreatedKnownSession((Session)session);
        }
        return session;
    }

    private void processPingMessage(ServerSessionFactory factory, Request<JsonElement> request, TransactionImpl.ResponseSender responseSender, String transportId) throws IOException {
        if (this.maxHeartbeats == 0 || this.maxHeartbeats > ++this.heartbeats) {
            JsonObject element;
            long interval = -1L;
            if (request.getParams() != null && (element = (JsonObject)request.getParams()).has(INTERVAL_PROPERTY)) {
                interval = element.get(INTERVAL_PROPERTY).getAsLong();
            }
            this.pingWachdogManager.pingReceived(transportId, interval);
            String sessionId = request.getSessionId();
            JsonObject pongPayload = new JsonObject();
            pongPayload.add("value", (JsonElement)new JsonPrimitive("pong"));
            responseSender.sendPingResponse((Message)new Response(sessionId, request.getId(), (Object)pongPayload));
        }
    }

    private void processCloseMessage(ServerSessionFactory factory, Request<JsonElement> request, TransactionImpl.ResponseSender responseSender, String transportId) {
        ServerSession session = this.sessionsManager.getByTransportId(transportId);
        if (session != null) {
            session.setGracefullyClosed();
            this.cancelCloseTimer(session);
        }
        try {
            responseSender.sendResponse((Message)new Response(request.getId(), (Object)"bye"));
        }
        catch (IOException e) {
            log.warn("Exception sending close message response to client", (Throwable)e);
        }
        if (session != null) {
            this.closeSession(session, CLIENT_CLOSED_CLOSE_REASON);
        }
    }

    private void processReconnectMessage(ServerSessionFactory factory, Request<JsonElement> request, TransactionImpl.ResponseSender responseSender, String transportId) throws IOException {
        String sessionId = request.getSessionId();
        if (sessionId == null) {
            ServerSession session = this.getOrCreateSession(factory, transportId, request);
            responseSender.sendResponse((Message)new Response(session.getSessionId(), request.getId(), (Object)"OK"));
        } else {
            ServerSession session = this.sessionsManager.get(sessionId);
            if (session != null) {
                String oldTransportId = session.getTransportId();
                session.setTransportId(transportId);
                factory.updateSessionOnReconnection(session);
                this.pingWachdogManager.updateTransportId(transportId, oldTransportId);
                this.sessionsManager.updateTransportId(session, oldTransportId);
                this.cancelCloseTimer(session);
                responseSender.sendResponse((Message)new Response(sessionId, request.getId(), (Object)"reconnection successful"));
            } else {
                session = this.createSessionAsOldIfKnowByHandler(factory, sessionId);
                if (session != null) {
                    responseSender.sendResponse((Message)new Response(sessionId, request.getId(), (Object)"reconnection successful"));
                } else {
                    responseSender.sendResponse((Message)new Response(request.getId(), new ResponseError(40007, "reconnection error")));
                }
            }
        }
    }

    private ServerSession createSession(ServerSessionFactory factory, Object registerInfo, String sessionId) {
        ServerSession session = factory.createSession(sessionId, registerInfo, this.sessionsManager);
        this.pingWachdogManager.associateSessionId(session.getTransportId(), sessionId);
        this.sessionsManager.put(session);
        return session;
    }

    private ServerSession createSession(ServerSessionFactory factory, Object registerInfo) {
        String sessionId = this.secretGenerator.nextSecret();
        return this.createSession(factory, registerInfo, sessionId);
    }

    private void processResponseMessage(JsonObject messagetJsonObject, String internalSessionId) {
        Response response = JsonUtils.fromJsonResponse((JsonObject)messagetJsonObject, JsonElement.class);
        ServerSession session = this.sessionsManager.getByTransportId(internalSessionId);
        if (session != null) {
            session.handleResponse((Response<JsonElement>)response);
        } else {
            log.debug("Processing response {} for non-existent session {}", (Object)response.toString(), (Object)internalSessionId);
        }
    }

    public void closeSessionIfTimeout(String transportId, final String reason) {
        final ServerSession session = this.sessionsManager.getByTransportId(transportId);
        if (session != null) {
            try {
                Date closeTime = new Date(System.currentTimeMillis() + session.getReconnectionTimeoutInMillis());
                log.debug(this.label + "Configuring close timeout for session: {} transportId: {} at {}", new Object[]{session.getSessionId(), transportId, format.format(closeTime)});
                ScheduledFuture lastStartedTimerFuture = this.taskScheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        ProtocolManager.this.closeSession(session, reason);
                    }
                }, closeTime);
                session.setCloseTimerTask(lastStartedTimerFuture);
                this.pingWachdogManager.disablePingWatchdogForSession(transportId);
            }
            catch (TaskRejectedException e) {
                log.warn(this.label + "Close timeout for session {} with transportId {} can not be set " + "because the scheduler is shutdown", (Object)session.getSessionId(), (Object)transportId);
            }
        }
    }

    public void closeSession(ServerSession session, String reason) {
        log.debug("{} Removing session {} with transportId {} in ProtocolManager", new Object[]{this.label, session.getSessionId(), session.getTransportId()});
        try {
            session.close();
        }
        catch (IOException e) {
            log.warn("{} Could not close WsSession session {}", new Object[]{this.label, session.getSessionId(), e});
        }
        this.sessionsManager.remove(session);
        this.pingWachdogManager.removeSession(session);
        this.handlerManager.afterConnectionClosed((Session)session, reason);
    }

    public void cancelCloseTimer(ServerSession session) {
        if (session.getCloseTimerTask() != null) {
            session.getCloseTimerTask().cancel(false);
        }
    }

    public void processTransportError(String transportId, Throwable exception) {
        ServerSession session = this.sessionsManager.getByTransportId(transportId);
        this.handlerManager.handleTransportError((Session)session, exception);
    }

    public void setMaxNumberOfHeartbeats(int maxHeartbeats) {
        this.maxHeartbeats = maxHeartbeats;
    }

    public void setPingWachdog(boolean pingWachdog) {
        this.pingWachdogManager.setPingWatchdog(pingWachdog);
    }

    public AbstractSession getSessionByTransportId(String transportId) {
        return this.sessionsManager.getByTransportId(transportId);
    }

    public static interface ServerSessionFactory {
        public ServerSession createSession(String var1, Object var2, SessionsManager var3);

        public void updateSessionOnReconnection(ServerSession var1);
    }
}

