/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.server.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContainerInitializer;
import org.apache.catalina.Context;
import org.apache.tomcat.websocket.server.WsSci;
import org.kurento.jsonrpc.JsonRpcHandler;
import org.kurento.jsonrpc.internal.http.JsonRpcHttpRequestHandler;
import org.kurento.jsonrpc.internal.server.PerSessionJsonRpcHandler;
import org.kurento.jsonrpc.internal.server.ProtocolManager;
import org.kurento.jsonrpc.internal.server.SessionsManager;
import org.kurento.jsonrpc.internal.server.config.DefaultJsonRpcHandlerRegistration;
import org.kurento.jsonrpc.internal.server.config.DefaultJsonRpcHandlerRegistry;
import org.kurento.jsonrpc.internal.server.config.JsonRpcProperties;
import org.kurento.jsonrpc.internal.ws.JsonRpcWebSocketHandler;
import org.kurento.jsonrpc.server.JsonRpcConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistration;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Configuration
@EnableWebSocket
public class JsonRpcConfiguration
implements WebSocketConfigurer {
    @Autowired
    protected ApplicationContext ctx;
    private final List<JsonRpcConfigurer> configurers = new ArrayList<JsonRpcConfigurer>();
    private DefaultJsonRpcHandlerRegistry instanceRegistry;

    private DefaultJsonRpcHandlerRegistry getJsonRpcHandlersRegistry() {
        if (this.instanceRegistry == null) {
            this.instanceRegistry = new DefaultJsonRpcHandlerRegistry();
            for (JsonRpcConfigurer configurer : this.configurers) {
                configurer.registerJsonRpcHandlers(this.instanceRegistry);
            }
        }
        return this.instanceRegistry;
    }

    @Autowired(required=false)
    public void setConfigurers(List<JsonRpcConfigurer> configurers) {
        if (!CollectionUtils.isEmpty(configurers)) {
            this.configurers.addAll(configurers);
        }
    }

    @Bean
    public JsonRpcProperties jsonRpcProperties() {
        return new JsonRpcProperties();
    }

    @Bean
    public HandlerMapping jsonRpcHandlerMapping() {
        DefaultJsonRpcHandlerRegistry registry = this.getJsonRpcHandlersRegistry();
        LinkedHashMap<String, Object> urlMap = new LinkedHashMap<String, Object>();
        for (DefaultJsonRpcHandlerRegistration registration : registry.getRegistrations()) {
            List paths;
            JsonRpcHandler handler;
            for (Map.Entry e : registration.getHandlerMap().entrySet()) {
                JsonRpcHandler handler2 = (JsonRpcHandler)e.getKey();
                List paths2 = (List)e.getValue();
                this.putHandlersMappings(urlMap, handler2, paths2);
            }
            for (Map.Entry e : registration.getPerSessionHandlerBeanNameMap().entrySet()) {
                String handlerBeanName = (String)e.getKey();
                handler = (JsonRpcHandler)this.ctx.getBean("perSessionJsonRpcHandler", new Object[]{handlerBeanName, null});
                paths = (List)e.getValue();
                this.putHandlersMappings(urlMap, handler, paths);
            }
            for (Map.Entry e : registration.getPerSessionHandlerClassMap().entrySet()) {
                Class handlerClass = (Class)e.getKey();
                handler = (JsonRpcHandler)this.ctx.getBean("perSessionJsonRpcHandler", new Object[]{null, handlerClass});
                paths = (List)e.getValue();
                this.putHandlersMappings(urlMap, handler, paths);
            }
        }
        SimpleUrlHandlerMapping hm = new SimpleUrlHandlerMapping();
        hm.setUrlMap(urlMap);
        hm.setOrder(1);
        return hm;
    }

    private void putHandlersMappings(Map<String, Object> urlMap, JsonRpcHandler<?> handler, List<String> paths) {
        JsonRpcHttpRequestHandler requestHandler = new JsonRpcHttpRequestHandler((ProtocolManager)this.ctx.getBean("protocolManager", new Object[]{handler}));
        for (String path : paths) {
            urlMap.put(path, requestHandler);
        }
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry wsHandlerRegistry) {
        DefaultJsonRpcHandlerRegistry registry = this.getJsonRpcHandlersRegistry();
        for (DefaultJsonRpcHandlerRegistration registration : registry.getRegistrations()) {
            List paths;
            JsonRpcHandler handler;
            for (Map.Entry e : registration.getHandlerMap().entrySet()) {
                JsonRpcHandler handler2 = (JsonRpcHandler)e.getKey();
                List paths2 = (List)e.getValue();
                this.publishWebSocketEndpoint(wsHandlerRegistry, handler2, paths2);
            }
            for (Map.Entry e : registration.getPerSessionHandlerBeanNameMap().entrySet()) {
                String handlerBeanName = (String)e.getKey();
                handler = (JsonRpcHandler)this.ctx.getBean("perSessionJsonRpcHandler", new Object[]{handlerBeanName, null});
                paths = (List)e.getValue();
                this.publishWebSocketEndpoint(wsHandlerRegistry, handler, paths);
            }
            for (Map.Entry e : registration.getPerSessionHandlerClassMap().entrySet()) {
                Class handlerClass = (Class)e.getKey();
                handler = (JsonRpcHandler)this.ctx.getBean("perSessionJsonRpcHandler", new Object[]{null, handlerClass});
                paths = (List)e.getValue();
                this.publishWebSocketEndpoint(wsHandlerRegistry, handler, paths);
            }
        }
    }

    private void publishWebSocketEndpoint(WebSocketHandlerRegistry wsHandlerRegistry, JsonRpcHandler<?> handler, List<String> paths) {
        ProtocolManager protocolManager = (ProtocolManager)this.ctx.getBean("protocolManager", new Object[]{handler});
        JsonRpcWebSocketHandler wsHandler = new JsonRpcWebSocketHandler(protocolManager);
        protocolManager.setPingWachdog(handler.isPingWatchdog());
        for (String path : paths) {
            WebSocketHandlerRegistration registration = wsHandlerRegistry.addHandler((WebSocketHandler)wsHandler, new String[]{path});
            List origins = handler.allowedOrigins();
            registration.setAllowedOrigins(origins.toArray(new String[origins.size()]));
            if (handler.isSockJSEnabled()) {
                registration.withSockJS().setSessionCookieNeeded(false);
            }
            if (handler.getLabel() == null) continue;
            wsHandler.setLabel(handler.getLabel());
        }
    }

    @Bean
    public TomcatEmbeddedServletContainerFactory tomcatContainerFactory() {
        TomcatEmbeddedServletContainerFactory factory = new TomcatEmbeddedServletContainerFactory();
        factory.setTomcatContextCustomizers(Arrays.asList(this.tomcatContextCustomizer()));
        return factory;
    }

    @Bean
    public TomcatContextCustomizer tomcatContextCustomizer() {
        return new TomcatContextCustomizer(){

            public void customize(Context context) {
                context.addServletContainerInitializer((ServletContainerInitializer)new WsSci(), null);
            }
        };
    }

    @Bean
    public SessionsManager sessionsManager() {
        return new SessionsManager();
    }

    @Bean
    @Scope(value="prototype")
    public ProtocolManager protocolManager(JsonRpcHandler<?> key) {
        return new ProtocolManager(key);
    }

    @Bean
    @Scope(value="prototype")
    public PerSessionJsonRpcHandler<?> perSessionJsonRpcHandler(String beanName, Class<? extends JsonRpcHandler<?>> beanClass) {
        return new PerSessionJsonRpcHandler(beanName, beanClass);
    }

    @Bean(destroyMethod="shutdown")
    public TaskScheduler jsonrpcTaskScheduler() {
        return new ThreadPoolTaskScheduler();
    }
}

