/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.ws;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.kurento.commons.PropertiesManager;
import org.kurento.commons.exception.KurentoException;
import org.kurento.jsonrpc.JsonRpcException;
import org.kurento.jsonrpc.JsonUtils;
import org.kurento.jsonrpc.TransportException;
import org.kurento.jsonrpc.client.Continuation;
import org.kurento.jsonrpc.internal.JsonRpcRequestSenderHelper;
import org.kurento.jsonrpc.internal.server.ServerSession;
import org.kurento.jsonrpc.internal.server.SessionsManager;
import org.kurento.jsonrpc.internal.ws.PendingRequests;
import org.kurento.jsonrpc.message.MessageUtils;
import org.kurento.jsonrpc.message.Request;
import org.kurento.jsonrpc.message.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class WebSocketServerSession
extends ServerSession {
    private static final long TIMEOUT = PropertiesManager.getProperty((String)"jsonRpcServerWebSocket.timeout", (int)10000);
    private static Logger log = LoggerFactory.getLogger(WebSocketServerSession.class);
    private WebSocketSession wsSession;
    private final PendingRequests pendingRequests = new PendingRequests();
    private ExecutorService execService = Executors.newCachedThreadPool();

    public WebSocketServerSession(String sessionId, Object registerInfo, SessionsManager sessionsManager, WebSocketSession wsSession) {
        super(sessionId, registerInfo, sessionsManager, wsSession.getId());
        this.wsSession = wsSession;
        this.setRsHelper(new JsonRpcRequestSenderHelper(sessionId){

            public <P, R> Response<R> internalSendRequest(Request<P> request, Class<R> resultClass) throws IOException {
                return WebSocketServerSession.this.sendRequestWebSocket(request, resultClass);
            }

            protected void internalSendRequest(Request<? extends Object> request, Class<JsonElement> resultClass, Continuation<Response<JsonElement>> continuation) {
                WebSocketServerSession.this.sendRequestWebSocket(request, resultClass, continuation);
            }
        });
    }

    protected void sendRequestWebSocket(final Request<? extends Object> request, final Class<JsonElement> resultClass, final Continuation<Response<JsonElement>> continuation) {
        this.execService.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Response result = WebSocketServerSession.this.sendRequestWebSocket(request, resultClass);
                    try {
                        continuation.onSuccess((Object)result);
                    }
                    catch (Exception e) {
                        log.error("Exception while processing response", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    continuation.onError((Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P, R> Response<R> sendRequestWebSocket(Request<P> request, Class<R> resultClass) {
        Response responseJsonObject;
        log.debug("Req-> {}", (Object)request.toString());
        ListenableFuture responseFuture = null;
        if (request.getId() != null) {
            responseFuture = this.pendingRequests.prepareResponse(request.getId());
        }
        try {
            WebSocketSession webSocketSession = this.wsSession;
            synchronized (webSocketSession) {
                this.wsSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)JsonUtils.toJson(request)));
            }
        }
        catch (Exception e) {
            throw new KurentoException("Exception while sending message '" + JsonUtils.toJson(request) + "' to websocket with native sessionId '" + this.wsSession.getId() + "'", (Throwable)e);
        }
        if (responseFuture == null) {
            return null;
        }
        try {
            responseJsonObject = (Response)responseFuture.get(TIMEOUT, TimeUnit.MILLISECONDS);
            log.debug("<-Res {}", (Object)responseJsonObject.toString());
        }
        catch (InterruptedException e) {
            throw new JsonRpcException("Interrupted while waiting for a response", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new JsonRpcException("This exception shouldn't be thrown", (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new TransportException("Timeout of " + TIMEOUT + " milliseconds waiting from response to request with id:" + request.getId() + ". Request: " + request, (Throwable)e);
        }
        return MessageUtils.convertResponse((Response)responseJsonObject, resultClass);
    }

    @Override
    public void handleResponse(Response<JsonElement> response) {
        this.pendingRequests.handleResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.execService.shutdown();
            this.wsSession.close();
        }
        finally {
            super.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWebSocketSession(WebSocketSession wsSession) {
        WebSocketSession webSocketSession = wsSession;
        synchronized (webSocketSession) {
            this.wsSession = wsSession;
        }
    }

    @Override
    public void closeNativeSession(String reason) {
        try {
            this.wsSession.close(new CloseStatus(CloseStatus.NORMAL.getCode(), reason));
        }
        catch (IOException e) {
            log.warn("Exception closing webSocket session", (Throwable)e);
        }
    }
}

