/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.unboundid;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import java.util.Arrays;
import javax.net.SocketFactory;
import org.ldaptive.ResultCode;
import org.ldaptive.provider.ControlHandler;
import org.ldaptive.provider.ControlProcessor;
import org.ldaptive.provider.ProviderConfig;
import org.ldaptive.provider.unboundid.UnboundIDControlHandler;

public class UnboundIDProviderConfig
extends ProviderConfig<Control> {
    private LDAPConnectionOptions connectionOptions;
    private SocketFactory socketFactory;
    private ResultCode[] searchIgnoreResultCodes;

    public UnboundIDProviderConfig() {
        this.setOperationExceptionResultCodes(new ResultCode[]{ResultCode.SERVER_DOWN});
        this.setControlProcessor(new ControlProcessor((ControlHandler)new UnboundIDControlHandler()));
        this.searchIgnoreResultCodes = new ResultCode[]{ResultCode.TIME_LIMIT_EXCEEDED, ResultCode.SIZE_LIMIT_EXCEEDED};
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public void setConnectionOptions(LDAPConnectionOptions options) {
        this.connectionOptions = options;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory sf) {
        this.checkImmutable();
        this.logger.trace("setting socketFactory: {}", (Object)sf);
        this.socketFactory = sf;
    }

    public ResultCode[] getSearchIgnoreResultCodes() {
        return this.searchIgnoreResultCodes;
    }

    public void setSearchIgnoreResultCodes(ResultCode[] codes) {
        this.checkImmutable();
        this.logger.trace("setting searchIgnoreResultCodes: {}", (Object)Arrays.toString(codes));
        this.searchIgnoreResultCodes = codes;
    }

    public String toString() {
        return String.format("[%s@%d::operationExceptionResultCodes=%s, properties=%s, connectionStrategy=%s, controlProcessor=%s, connectionOptions=%s, socketFactory=%s, searchIgnoreResultCodes=%s]", ((Object)((Object)this)).getClass().getName(), ((Object)((Object)this)).hashCode(), Arrays.toString(this.getOperationExceptionResultCodes()), this.getProperties(), this.getConnectionStrategy(), this.getControlProcessor(), this.connectionOptions, this.socketFactory, Arrays.toString(this.searchIgnoreResultCodes));
    }
}

