/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.AbstractFlowCommand;
import com.datical.liquibase.ext.command.FlowValidateCommandStep;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.file.FlowFile;
import com.datical.liquibase.ext.flow.file.Stage;
import com.datical.liquibase.ext.flow.provider.StageGlobalArgsValueProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResults;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;

public class FlowCommandStep
extends AbstractFlowCommand {
    public static final String[] COMMAND_NAME = new String[]{"flow"};
    public static final CommandArgumentDefinition<String> FLOW_FILE;
    public static final CommandArgumentDefinition<String> FLOW_INTEGRATION;
    public static final CommandArgumentDefinition<Boolean> FLOW_FILE_STRICT_PARSING;
    public static final String DEFAULT_FLOW_FILE_NAME = "liquibase.flowfile.yaml";
    public static final String BANNER = "******************************************************************************";
    private Boolean validated;

    @Override
    public void validate(CommandScope commandScope) {
        super.validate(commandScope);
        try {
            CommandScope commandScope2 = new CommandScope(FlowValidateCommandStep.COMMAND_NAME);
            for (Map.Entry entry : commandScope2.getCommand().getArguments().entrySet()) {
                commandScope2.addArgumentValue((String)entry.getKey(), commandScope.getArgumentValue((CommandArgumentDefinition)entry.getValue()));
            }
            CommandResults commandResults = commandScope2.execute();
            this.validated = (Boolean)commandResults.getResult("validated");
            return;
        }
        catch (CommandExecutionException commandExecutionException) {
            throw new CommandValidationException("Error during validation: " + commandExecutionException.getMessage());
        }
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        if (this.validated == null || Boolean.FALSE.equals(this.validated)) {
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        Object object = commandResultsBuilder.getCommandScope();
        if ((object = this.loadFlowFileContents((String)object.getArgumentValue(FLOW_FILE), (String)object.getArgumentValue(FLOW_INTEGRATION), (Boolean)object.getArgumentValue(FLOW_FILE_STRICT_PARSING) == false)) == null) {
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        LinkedHashMap<String, Stage> linkedHashMap = ((FlowFile)object).getStages();
        if (linkedHashMap == null || linkedHashMap.isEmpty()) {
            Scope.getCurrentScope().getUI().sendMessage("No stages found.");
        } else {
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                String string = (String)entry.getKey();
                Stage object2 = (Stage)entry.getValue();
                this.executeStage(object2, string, commandResultsBuilder);
            }
        }
        this.executeStage(((FlowFile)object).getEndStage(), "endStage", commandResultsBuilder);
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    private void executeStage(Stage stage, String string, CommandResultsBuilder commandResultsBuilder) {
        if (stage == null) {
            Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Empty stage '" + string + "' found"));
            return;
        }
        if (stage.getActions() == null || stage.getActions().isEmpty()) {
            Scope.getCurrentScope().getUI().sendMessage(this.createBanner("No actions found for Stage: ".concat(String.valueOf(string))));
            return;
        }
        LiquibaseConfiguration liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
        StageGlobalArgsValueProvider stageGlobalArgsValueProvider = new StageGlobalArgsValueProvider(stage.getGlobalArgs());
        try {
            liquibaseConfiguration.registerProvider((ConfigurationValueProvider)stageGlobalArgsValueProvider);
            Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Executing Stage: ".concat(String.valueOf(string))));
            for (Action action : stage.getActions()) {
                this.runAction(commandResultsBuilder, action);
            }
            if (stage.getAfterActions() == null || stage.getAfterActions().isEmpty()) {
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("No after actions found for Stage: ".concat(String.valueOf(string))));
                return;
            }
            for (Action action : stage.getAfterActions()) {
                this.runAction(commandResultsBuilder, action);
            }
            return;
        }
        finally {
            liquibaseConfiguration.unregisterProvider((ConfigurationValueProvider)stageGlobalArgsValueProvider);
        }
    }

    private void runAction(CommandResultsBuilder commandResultsBuilder, Action action) {
        Scope.getCurrentScope().getUI().sendMessage(this.createBanner(String.format("Executing %s", action)));
        action.execute(commandResultsBuilder);
        Scope.getCurrentScope().getUI().sendMessage("");
    }

    private String createBanner(String string) {
        return String.format("%s%n* %n* %s%n* %n%s%n", BANNER, string, BANNER);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Run a series of commands contained in one or more stages, as configured in a liquibase flow-file.");
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        FLOW_FILE = commandBuilder.argument("flowFile", String.class).defaultValue((Object)DEFAULT_FLOW_FILE_NAME).description("The path to the configuration yaml file which contains one or more 'stages' of commands to be executed in a liquibase flow operation. Defaults to yaml file named \"liquibase.flowfile.yaml\" in the current working directory.").build();
        FLOW_INTEGRATION = commandBuilder.argument("flowIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing flow").build();
        FLOW_FILE_STRICT_PARSING = commandBuilder.argument("flowFileStrictParsing", Boolean.class).defaultValue((Object)Boolean.TRUE).description("Parse flow-file YAML to allow only Liquibase flow-file specific properties, indentations, and structure.").build();
    }
}

