/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;
import liquibase.license.LicenseServiceUtils;
import liquibase.resource.InputStreamList;
import liquibase.util.StringUtil;

public abstract class AbstractChecksCommandStep
extends AbstractCommandStep {
    private static final String NULL_INPUT_EXCEPTION_MESSAGE = "WARNING:  Severity value '' is not valid.  Options: '0', '1', '2', '3', '4', 'INFO', 'MINOR', 'MAJOR', 'CRITICAL', 'BLOCKER'";
    private static final String WRONG_NUMBER_INPUT_EXCEPTION_MESSAGE = "WARNING:  Severity value '%s' is not valid.  Options: '0', '1', '2', '3', '4'";
    private static final String WRONG_STRING_INPUT_EXCEPTION_MESSAGE = "WARNING:  Severity value '%s' is not valid.  Options: 'INFO', 'MINOR', 'MAJOR', 'CRITICAL', 'BLOCKER'";

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        String string = "";
        if (this.isSeverityModificationCommand(commandDefinition)) {
            string = "The severity level of a check can be customized to determine its return codes:" + System.lineSeparator() + "Enter \"INFO\" for return code: 0" + System.lineSeparator() + "Enter \"MINOR\" for return code: 1" + System.lineSeparator() + "Enter \"MAJOR\" for return code: 2" + System.lineSeparator() + "Enter \"CRITICAL\" for return code: 3" + System.lineSeparator() + "Enter \"BLOCKER\" for return code: 4" + System.lineSeparator() + System.lineSeparator();
        }
        commandDefinition.setHelpFooter("\nNOTES\n" + string + "Liquibase Pro users can enable and customize as many rules as they want!" + System.lineSeparator() + "Learn more about Liquibase Quality Checks at:" + System.lineSeparator() + "https://docs.liquibase.com/quality-checks" + System.lineSeparator() + "Get your FREE Pro trial today https://liquibase.com/trial and add it to your defaults file or use in an Environment variable.");
        if (this.isSeverityModificationCommand(commandDefinition)) {
            CommandDefinition commandDefinition2 = commandDefinition;
            commandDefinition2.setGroupHelpFooter(commandDefinition2.getHelpFooter());
        }
    }

    public void validate(CommandScope commandScope) {
        if (this.commandRequiresProLicense()) {
            LicenseServiceUtils.checkProLicenseAndThrowException((String[])commandScope.getCommand().getName());
        }
        super.validate(commandScope);
    }

    public boolean commandRequiresProLicense() {
        return true;
    }

    protected boolean isMavenIntegration(CommandResultsBuilder object) {
        object = object.getCommandScope();
        String string = (String)object.getConfiguredValue(ChecksRunCommandStep.CHECKS_INTEGRATION_ARG).getValue();
        object = (String)object.getConfiguredValue(ChecksRunCommandStep.CHECKS_SETTINGS_FILE_ARG).getValue();
        return string.equalsIgnoreCase("maven") && StringUtil.isEmpty((String)object);
    }

    private boolean isSeverityModificationCommand(CommandDefinition commandDefinition) {
        return commandDefinition.getName().length > 1 && commandDefinition.getName()[0].equals("checks") && (commandDefinition.getName()[1].equals("customize") || commandDefinition.getName()[1].equals("copy"));
    }

    protected static boolean modifySeverity(AbstractConfigurableRule abstractConfigurableRule) {
        Optional<SeverityEnum> optional = abstractConfigurableRule.getSeverity().toString();
        optional = (String)Scope.getCurrentScope().getUI().prompt("Set the Severity to return a code of 0-4 when triggered. (options: 'INFO'|0, 'MINOR'|1, 'MAJOR'|2, 'CRITICAL'|3, 'BLOCKER'|4)?", (Object)optional, (string, severityEnumArray) -> {
            severityEnumArray = SeverityEnum.values();
            if (string == null) {
                throw new IllegalArgumentException(NULL_INPUT_EXCEPTION_MESSAGE);
            }
            if (StringUtil.isNumeric((CharSequence)string)) {
                return Arrays.stream(severityEnumArray).filter(severityEnum -> string.equals(Integer.toString(severityEnum.getExitValue()))).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(WRONG_NUMBER_INPUT_EXCEPTION_MESSAGE, string))).name();
            }
            return Arrays.stream(severityEnumArray).filter(severityEnum -> string.equalsIgnoreCase(severityEnum.name())).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format(WRONG_STRING_INPUT_EXCEPTION_MESSAGE, string))).name();
        }, String.class);
        optional = Arrays.stream(SeverityEnum.values()).filter(arg_0 -> AbstractChecksCommandStep.lambda$modifySeverity$5((String)((Object)optional), arg_0)).findFirst();
        if (optional.isPresent() && !abstractConfigurableRule.getSeverity().equals(optional.get())) {
            abstractConfigurableRule.setSeverity((SeverityEnum)((Object)optional.get()));
            return true;
        }
        return false;
    }

    protected static AbstractLiquibaseRule findConfigurableParentRule(AbstractConfigurableRule object, List<AbstractLiquibaseRule> list, String string, String string2) {
        if (!((Optional)(object = ((AbstractConfigurableRule)object).findParentRule(list))).isPresent()) {
            throw new CommandExecutionException(System.lineSeparator() + System.lineSeparator() + "Check '" + string + "' was copied from a rule which does not exist.  Run 'liquibase checks show' to see a list of available checks.");
        }
        if (!((AbstractLiquibaseRule)(object = (AbstractLiquibaseRule)((Optional)object).get())).isConfigurable()) {
            throw new CommandExecutionException(System.lineSeparator() + System.lineSeparator() + "Check '" + string + "' " + string2 + "." + System.lineSeparator() + "Run 'liquibase checks show' to see a list of all available checks and customization options for checks.");
        }
        return object;
    }

    public static List<AbstractLiquibaseRule> listAllRules() {
        ArrayList<AbstractLiquibaseRule> arrayList = new ArrayList<AbstractLiquibaseRule>(Scope.getCurrentScope().getServiceLocator().findInstances(AbstractLiquibaseRule.class));
        Collections.sort(arrayList);
        return arrayList;
    }

    public static AbstractLiquibaseRule findRuleByShortName(String string) {
        return AbstractChecksCommandStep.findRuleByShortName(AbstractChecksCommandStep.listAllRules(), string);
    }

    public static AbstractLiquibaseRule findRuleByShortName(List<AbstractLiquibaseRule> object, String string) {
        if (((Optional)(object = object.stream().filter(abstractLiquibaseRule -> abstractLiquibaseRule.getShortName().equalsIgnoreCase(string)).findFirst())).isPresent()) {
            return (AbstractLiquibaseRule)((Optional)object).get();
        }
        throw new CommandExecutionException("\n\nCheck '" + string + "' does not exist.  Run 'liquibase checks show' to see a list of available checks.");
    }

    protected static void checkFileArgExistence(String string, String string2, boolean bl2) {
        if (StringUtil.isEmpty((String)string)) {
            return;
        }
        if (!AbstractChecksCommandStep.doesFileExist(string, string2, bl2)) {
            throw new IllegalArgumentException(String.format("%nWARNING: The %s file '%s' was not located. Correct this issue and try to run checks again.", string2, string));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean doesFileExist(String string, String string2, boolean bl2) {
        if (!bl2) return new File(string).exists();
        try {
            Throwable throwable = null;
            try (InputStreamList inputStreamList = Scope.getCurrentScope().getResourceAccessor().openStreams(null, string);){
                if (inputStreamList == null) return false;
                if (inputStreamList.isEmpty()) {
                    return false;
                }
                if (inputStreamList.size() <= 1) return true;
                throw new IllegalArgumentException(String.format("%nFound multiple %s files named '%s'. Correct this issue and try to run checks again.", string2, string));
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(String.format("%nError reading %s settings file '%s': %s%nCorrect this issue and try to run checks again.", string2, string, iOException.getMessage()));
        }
    }

    private static /* synthetic */ boolean lambda$modifySeverity$5(String string, SeverityEnum severityEnum) {
        return string.equalsIgnoreCase(severityEnum.name());
    }
}

