/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.rules.annotation.Action;
import com.datical.liquibase.ext.rules.annotation.Condition;
import com.datical.liquibase.ext.rules.annotation.Fact;
import com.datical.liquibase.ext.rules.annotation.Priority;
import com.datical.liquibase.ext.rules.annotation.Rule;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.core.ActionMethodOrderBean;
import com.datical.liquibase.ext.rules.core.NoSuchFactException;
import com.datical.liquibase.ext.rules.core.RuleDefinitionValidator;
import com.datical.liquibase.ext.rules.core.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import liquibase.Scope;
import liquibase.logging.Logger;

public class RuleProxy
implements InvocationHandler {
    private final Object target;
    private String name;
    private String description;
    private Integer priority;
    private Method[] methods;
    private Method conditionMethod;
    private Set<ActionMethodOrderBean> actionMethods;
    private Method compareToMethod;
    private Method toStringMethod;
    private Rule annotation;
    private static final RuleDefinitionValidator ruleDefinitionValidator = new RuleDefinitionValidator();

    public static com.datical.liquibase.ext.rules.api.Rule asRule(Object object) {
        if (object instanceof com.datical.liquibase.ext.rules.api.Rule) {
            object = (com.datical.liquibase.ext.rules.api.Rule)object;
        } else {
            ruleDefinitionValidator.validateRuleDefinition(object);
            object = (com.datical.liquibase.ext.rules.api.Rule)Proxy.newProxyInstance(com.datical.liquibase.ext.rules.api.Rule.class.getClassLoader(), new Class[]{com.datical.liquibase.ext.rules.api.Rule.class, Comparable.class}, (InvocationHandler)new RuleProxy(object));
        }
        return object;
    }

    private RuleProxy(Object object) {
        this.target = object;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        switch (method.getName()) {
            case "getName": {
                return this.getRuleName();
            }
            case "getDescription": {
                return this.getRuleDescription();
            }
            case "getPriority": {
                return this.getRulePriority();
            }
            case "compareTo": {
                return this.compareToMethod(objectArray);
            }
            case "evaluate": {
                return this.evaluateMethod(objectArray);
            }
            case "execute": {
                return this.executeMethod(objectArray);
            }
            case "equals": {
                return this.equalsMethod(objectArray);
            }
            case "hashCode": {
                return this.hashCodeMethod();
            }
            case "toString": {
                return this.toStringMethod();
            }
        }
        return null;
    }

    private Object evaluateMethod(Object[] object) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        object = (Facts)object[0];
        Method method = this.getConditionMethod();
        try {
            List<Object> list = this.getActualParameters(method, (Facts)object);
            return method.invoke(this.target, list.toArray());
        }
        catch (NoSuchFactException noSuchFactException) {
            logger.warning("Rule '" + this.getTargetClass().getName() + "' has been evaluated to false due to a declared but missing fact '" + noSuchFactException.getMissingFact() + "' in " + object, (Throwable)noSuchFactException);
            return Boolean.FALSE;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.warning("Types of injected facts in method '" + method.getName() + "' in rule '" + this.getTargetClass().getName() + "' do not match parameters types", (Throwable)illegalArgumentException);
            return Boolean.FALSE;
        }
    }

    private Object executeMethod(Object[] object) {
        object = (Facts)object[0];
        Iterator<ActionMethodOrderBean> iterator = this.getActionMethodBeans().iterator();
        while (iterator.hasNext()) {
            Method method = iterator.next().getMethod();
            List<Object> list = this.getActualParameters(method, (Facts)object);
            method.invoke(this.target, list.toArray());
        }
        return null;
    }

    private Object compareToMethod(Object[] object) {
        Method method = this.getCompareToMethod();
        object = object[0];
        if (method != null && Proxy.isProxyClass(object.getClass())) {
            if (method.getParameters().length != 1) {
                throw new IllegalArgumentException("compareTo method must have a single argument");
            }
            object = (RuleProxy)Proxy.getInvocationHandler(object);
            return method.invoke(this.target, ((RuleProxy)object).getTarget());
        }
        return this.compareTo((com.datical.liquibase.ext.rules.api.Rule)object);
    }

    private List<Object> getActualParameters(Method annotationArray, Facts facts) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object : annotationArray.getParameterAnnotations()) {
            if (((Annotation[])object).length == 1) {
                Object t2 = facts.get((String)(object = ((Fact)object[0]).value()));
                if (t2 == null && !facts.asMap().containsKey(object)) {
                    throw new NoSuchFactException(String.format("No fact named '%s' found in known facts: %n%s", object, facts), (String)object);
                }
                arrayList.add(t2);
                continue;
            }
            arrayList.add(facts);
        }
        return arrayList;
    }

    private boolean equalsMethod(Object[] object) {
        if (!(object[0] instanceof com.datical.liquibase.ext.rules.api.Rule)) {
            return false;
        }
        object = (com.datical.liquibase.ext.rules.api.Rule)object[0];
        int n2 = object.getPriority();
        if (this.getRulePriority() != n2) {
            return false;
        }
        String string = object.getName();
        if (!this.getRuleName().equals(string)) {
            return false;
        }
        object = object.getDescription();
        return Objects.equals(this.getRuleDescription(), object);
    }

    private int hashCodeMethod() {
        int n2 = this.getRuleName().hashCode();
        int n3 = this.getRulePriority();
        String string = this.getRuleDescription();
        return (n2 * 31 + (string != null ? string.hashCode() : 0)) * 31 + n3;
    }

    private Method getToStringMethod() {
        if (this.toStringMethod == null) {
            for (Method method : this.getMethods()) {
                if (!"toString".equals(method.getName())) continue;
                this.toStringMethod = method;
                return this.toStringMethod;
            }
        }
        return this.toStringMethod;
    }

    private String toStringMethod() {
        Method method = this.getToStringMethod();
        if (method != null) {
            return (String)method.invoke(this.target, new Object[0]);
        }
        return this.getRuleName();
    }

    private int compareTo(com.datical.liquibase.ext.rules.api.Rule object) {
        int n2 = object.getPriority();
        int n3 = this.getRulePriority();
        if (n3 < n2) {
            return -1;
        }
        if (n3 > n2) {
            return 1;
        }
        object = object.getName();
        return this.getRuleName().compareTo((String)object);
    }

    private int getRulePriority() {
        if (this.priority == null) {
            int n2 = 0x7FFFFFFE;
            Method[] methodArray = this.getRuleAnnotation();
            if (methodArray.priority() != 0x7FFFFFFE) {
                n2 = methodArray.priority();
            }
            for (Method method : this.getMethods()) {
                if (!method.isAnnotationPresent(Priority.class)) continue;
                n2 = (Integer)method.invoke(this.target, new Object[0]);
                break;
            }
            this.priority = n2;
        }
        return this.priority;
    }

    private Method getConditionMethod() {
        if (this.conditionMethod == null) {
            for (Method method : this.getMethods()) {
                if (!method.isAnnotationPresent(Condition.class)) continue;
                this.conditionMethod = method;
                return this.conditionMethod;
            }
        }
        return this.conditionMethod;
    }

    private Set<ActionMethodOrderBean> getActionMethodBeans() {
        if (this.actionMethods == null) {
            this.actionMethods = new TreeSet<ActionMethodOrderBean>();
            for (Method method : this.getMethods()) {
                if (!method.isAnnotationPresent(Action.class)) continue;
                int n2 = method.getAnnotation(Action.class).order();
                this.actionMethods.add(new ActionMethodOrderBean(method, n2));
            }
        }
        return this.actionMethods;
    }

    private Method getCompareToMethod() {
        if (this.compareToMethod == null) {
            for (Method method : this.getMethods()) {
                if (!method.getName().equals("compareTo")) continue;
                this.compareToMethod = method;
                return this.compareToMethod;
            }
        }
        return this.compareToMethod;
    }

    private Method[] getMethods() {
        if (this.methods == null) {
            this.methods = this.getTargetClass().getMethods();
        }
        return this.methods;
    }

    private Rule getRuleAnnotation() {
        if (this.annotation == null) {
            this.annotation = Utils.findAnnotation(Rule.class, this.getTargetClass());
        }
        return this.annotation;
    }

    private String getRuleName() {
        if (this.name == null) {
            Rule rule = this.getRuleAnnotation();
            this.name = rule.name().equals("rule") ? this.getTargetClass().getSimpleName() : rule.name();
        }
        return this.name;
    }

    private String getRuleDescription() {
        if (this.description == null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendConditionMethodName(stringBuilder);
            this.appendActionMethodsNames(stringBuilder);
            Rule rule = this.getRuleAnnotation();
            this.description = rule.description().equals("description") ? stringBuilder.toString() : rule.description();
        }
        return this.description;
    }

    private void appendConditionMethodName(StringBuilder stringBuilder) {
        Method method = this.getConditionMethod();
        if (method != null) {
            stringBuilder.append("when ");
            stringBuilder.append(method.getName());
            stringBuilder.append(" then ");
        }
    }

    private void appendActionMethodsNames(StringBuilder stringBuilder) {
        Iterator<ActionMethodOrderBean> iterator = this.getActionMethodBeans().iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next().getMethod().getName());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
    }

    public Object getTarget() {
        return this.target;
    }

    private Class<?> getTargetClass() {
        return this.target.getClass();
    }
}

