/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.delete.Delete;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.LimitValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class DeleteValidator
extends AbstractValidator<Delete> {
    @Override
    public void validate(Delete delete) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, Feature.delete);
            this.validateOptionalFeature(validationCapability, delete.getTables(), Feature.deleteTables);
            this.validateOptionalFeature(validationCapability, delete.getJoins(), Feature.deleteJoin);
            this.validateOptionalFeature(validationCapability, delete.getLimit(), Feature.deleteLimit);
            this.validateOptionalFeature(validationCapability, delete.getOrderByElements(), Feature.deleteOrderBy);
            this.validateOptionalFeature(validationCapability, delete.getReturningExpressionList(), Feature.insertReturningExpressionList);
        }
        SelectValidator selectValidator = this.getValidator(SelectValidator.class);
        delete.getTable().accept(selectValidator);
        if (this.isNotEmpty(delete.getTables())) {
            delete.getTables().forEach(table -> table.accept(selectValidator));
        }
        this.validateOptionalExpression(delete.getWhere());
        this.validateOptionalOrderByElements(delete.getOrderByElements());
        selectValidator.validateOptionalJoins(delete.getJoins());
        if (delete.getLimit() != null) {
            this.getValidator(LimitValidator.class).validate(delete.getLimit());
        }
        if (this.isNotEmpty(delete.getReturningExpressionList())) {
            delete.getReturningExpressionList().forEach(selectItem -> selectItem.accept(selectValidator));
        }
    }
}

