/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.cli;

import com.datical.liquibase.ext.checks.config.cli.AbstractCommandLineValueGetter;
import java.util.Arrays;
import liquibase.util.StringUtil;

public class EnumGetter<E extends Enum>
extends AbstractCommandLineValueGetter<E> {
    private final Class<E> e;
    private final boolean ignoreCase;

    public EnumGetter(Class<E> e, boolean ignoreCase) {
        super(e);
        this.e = e;
        this.ignoreCase = ignoreCase;
    }

    @Override
    public boolean validate(E input) {
        return true;
    }

    @Override
    public E convert(String input) {
        if (this.ignoreCase) {
            return EnumGetter.getEnumIgnoreCase(input, this.e);
        }
        return Enum.valueOf(this.e, input);
    }

    public static <T extends Enum> T getEnumIgnoreCase(String name, Class<T> enumClass) {
        return (T)Arrays.stream(enumClass.getEnumConstants()).filter(e -> e.name().equalsIgnoreCase(name)).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find matching value. Valid options include: '%s'.", StringUtil.join((Object[])enumClass.getEnumConstants(), (String)"', '", Object::toString))));
    }
}

