/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.OperatorEnum;
import com.datical.liquibase.ext.checks.config.cli.RegexGetter;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public abstract class AbstractChangeSetParameterRegexCheck
extends AbstractLiquibaseDynamicForecastRule {
    public abstract String getErrorMessage(String var1, OperatorEnum var2, String var3);

    public abstract Set<String> getChangeSetParameters(ChangeSet var1);

    public abstract Optional<String> getAssembledChangeSetParameters(ChangeSet var1);

    public abstract String getSimpleName();

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        return this.doEvaluate(changeSet, dynamicRule);
    }

    private boolean doEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        String searchString = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.SEARCH_STRING);
        OperatorEnum operator = dynamicRule.getEnumParameterValue(DynamicRuleParameterEnum.OPERATOR, OperatorEnum.class);
        Set<String> parameters = this.getChangeSetParameters(changeSet);
        boolean validChangeset = parameters.stream().map(parameter -> parameter.replace("(", "")).map(parameter -> parameter.replace(")", "")).anyMatch(parameter -> !parameter.isEmpty() && operator.matches(searchString, (String)parameter, false));
        if (!validChangeset) {
            return this.putResultUnsuccessful(changeSet, this.getErrorMessage(this.getAssembledChangeSetParameters(changeSet).orElse(""), operator, searchString), (AbstractConfigurableRule)dynamicRule);
        }
        return this.putResultSuccessful(changeSet, true, (AbstractConfigurableRule)dynamicRule);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, Database database, DynamicRule dr) {
        return this.doEvaluate(changeSet, dr);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.OPERATOR), new RuleParameter<String>(DynamicRuleParameterEnum.SEARCH_STRING, (value, newParameterValues) -> {
            Optional<DynamicRuleParameter> operatorParamOpt = newParameterValues.stream().filter(pv -> pv.getParameterAsEnum() == DynamicRuleParameterEnum.OPERATOR).findFirst();
            DynamicRuleParameter operatorParam = operatorParamOpt.orElseThrow(() -> new IllegalArgumentException("Operator is required."));
            if (operatorParam.getValue() == OperatorEnum.REGEXP) {
                return new RegexGetter().validate((String)value);
            }
            if (StringUtil.isEmpty((String)value)) {
                throw new IllegalArgumentException("Search string may not be empty.");
            }
            if (value.contains(" ")) {
                throw new IllegalArgumentException("Search string may not contain spaces.");
            }
            if (value.contains(",")) {
                throw new IllegalArgumentException(String.format("ERROR: The search string cannot contain a comma, as %s do not allow literal comma usage. To search for multiple terms in changeset %s, create one check per term.", this.getSimpleName().toLowerCase(), this.getSimpleName().toLowerCase()));
            }
            if (!value.matches("^[a-zA-Z0-9_-]+$")) {
                throw new IllegalArgumentException(String.format("The %s search string is not valid. %s may contain alphanumeric characters, hyphens, and underscores.", operatorParam.getValue(), this.getSimpleName()));
            }
            return true;
        }, null));
    }

    @Override
    public List<String> getSupportedChangesetFormats() {
        return AbstractLiquibaseRule.SupportedChangesetFormats.ALL;
    }
}

