/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.ChangesetAttributes;
import com.datical.liquibase.ext.checks.dynamic.AbstractChangesetAttributesRule;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ChangesetAttributesAndValue
extends AbstractChangesetAttributesRule {
    @Override
    protected boolean equalityCheck(String changesetAttribute, String searchString) {
        return Pattern.matches(searchString, changesetAttribute);
    }

    @Override
    protected String getFailureMessage(List<ChangesetAttributes> wrongAttributes, String searchString) {
        return "The attribute '" + StringUtils.join(wrongAttributes, (String)", ") + "' does not match the required pattern '" + searchString + "'.";
    }

    @Override
    public String getShortName() {
        return "ChangesetAttributesAndValue";
    }

    @Override
    public Class<?> getPermittedType() {
        return String.class;
    }

    @Override
    public String getDescription() {
        return "This check triggers when specified attributes do not match the user-supplied string or regex pattern.";
    }

    @Override
    public boolean allowMultipleAttributes() {
        return false;
    }

    @Override
    public int getPriority() {
        return 512;
    }
}

