/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.diff;

import java.util.Set;
import liquibase.serializer.AbstractLiquibaseSerializable;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Schema;

public class FormattedDiffObject
extends AbstractLiquibaseSerializable {
    private String name;
    private String type;
    private String relationName;
    private String schemaName;
    private String catalogName;
    private String tablespace;
    private String objectTypeHeader;

    public FormattedDiffObject() {
    }

    public FormattedDiffObject(DatabaseObject databaseObject, String objectTypeHeader) {
        String tablespace;
        Schema schema;
        this.name = (String)databaseObject.getAttribute("name", null);
        this.type = databaseObject.getObjectTypeName();
        Relation relation = (Relation)databaseObject.getAttribute("relation", null);
        if (relation != null) {
            this.relationName = relation.getName();
        }
        if ((schema = databaseObject.getSchema()) != null) {
            this.schemaName = schema.getName();
            Catalog catalog = schema.getCatalog();
            if (catalog != null) {
                this.catalogName = catalog.getName();
            }
        }
        if ((tablespace = (String)databaseObject.getAttribute("tablepace", null)) != null) {
            this.tablespace = tablespace;
        }
        this.objectTypeHeader = objectTypeHeader;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public void setRelationName(String relationName) {
        this.relationName = relationName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public Set<String> getSerializableFields() {
        Set fields = super.getSerializableFields();
        fields.remove("objectTypeHeader");
        return fields;
    }

    public String getSerializedObjectName() {
        if (this.objectTypeHeader != null) {
            return this.objectTypeHeader;
        }
        return "formattedDiffObject";
    }

    public String getSerializedObjectNamespace() {
        return "";
    }
}

