/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.diff;

import com.datical.liquibase.ext.diff.FormattedChangeObject;
import com.datical.liquibase.ext.diff.FormattedDiffModel;
import com.datical.liquibase.ext.diff.FormattedDiffObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.serializer.core.json.JsonChangeLogSerializer;

public class FormattedDiffSerializer
extends JsonChangeLogSerializer {
    private final List<String> topLevelAttributes = new ArrayList<String>(Arrays.asList("diffFormat", "created", "databases", "missingObjects", "unexpectedObjects", "changedObjects"));
    private final List<String> changedLevelAttributes = new ArrayList<String>(Arrays.asList("name", "type", "relationName", "schemaName", "catalogName", "tablespace", "differences"));

    protected Comparator<String> getComparator(LiquibaseSerializable object) {
        if (object instanceof FormattedDiffModel) {
            return new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return FormattedDiffSerializer.this.compareWorker(FormattedDiffSerializer.this.topLevelAttributes, o1, o2);
                }
            };
        }
        if (object instanceof FormattedChangeObject || object instanceof FormattedDiffObject) {
            return new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return FormattedDiffSerializer.this.compareWorker(FormattedDiffSerializer.this.changedLevelAttributes, o1, o2);
                }
            };
        }
        return super.getComparator(object);
    }

    protected Set<String> getSerializableObjectFields(LiquibaseSerializable object) {
        Set fields = object.getSerializableFields();
        fields.remove("snapshotId");
        return fields;
    }

    private int compareWorker(List<String> attributes, String o1, String o2) {
        int pos2;
        if (!attributes.contains(o1) || !attributes.contains(o2)) {
            return o1.compareTo(o2);
        }
        int pos1 = attributes.indexOf(o1);
        if (pos1 > (pos2 = attributes.indexOf(o2))) {
            return 1;
        }
        if (pos1 < pos2) {
            return -1;
        }
        return 0;
    }

    public int getPriority() {
        return -1;
    }
}

