/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.logging.structured;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.license.LicenseServiceUtils;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcManager;
import liquibase.logging.mdc.MdcObject;

public class StructuredMdcManager
implements MdcManager {
    private static final ThreadLocal<Map<String, Map<String, Object>>> mdc = ThreadLocal.withInitial(LinkedHashMap::new);
    private static final ThreadLocal<Map<String, Object>> scopeIgnorantMdc = ThreadLocal.withInitial(LinkedHashMap::new);

    public MdcObject put(String key, String value) {
        return this.put(key, (Object)value, true);
    }

    public MdcObject put(String key, String value, boolean removeWhenScopeExits) {
        return this.put(key, (Object)value, removeWhenScopeExits);
    }

    public MdcObject put(String key, Map<String, Object> values) {
        return this.put(key, (Object)values, true);
    }

    public MdcObject put(String key, Map<String, Object> values, boolean removeWhenScopeExits) {
        return this.put(key, (Object)values, removeWhenScopeExits);
    }

    public MdcObject put(String key, List<? extends CustomMdcObject> values) {
        return this.put(key, values, true);
    }

    public MdcObject put(String key, CustomMdcObject customMdcObject) {
        return this.put(key, (Object)customMdcObject, true);
    }

    public MdcObject put(String key, CustomMdcObject customMdcObject, boolean removeWhenScopeExits) {
        return this.put(key, (Object)customMdcObject, removeWhenScopeExits);
    }

    private MdcObject put(String key, Object object, boolean removeWhenScopeExits) {
        if (removeWhenScopeExits) {
            Map<String, Object> scopeMdc = this.getMdcForScope(Scope.getCurrentScope().getScopeId());
            scopeMdc.put(key, object);
        } else {
            scopeIgnorantMdc.get().put(key, object);
        }
        return new MdcObject(key, object);
    }

    private Map<String, Object> getMdcForScope(String scopeId) {
        return mdc.get().computeIfAbsent(scopeId, k -> new HashMap());
    }

    public void remove(String key) {
        this.getMdcForScope(Scope.getCurrentScope().getScopeId()).remove(key);
        scopeIgnorantMdc.get().remove(key);
    }

    public void clear() {
        mdc.remove();
        scopeIgnorantMdc.remove();
    }

    public int getPriority() {
        if (LicenseServiceUtils.isProLicenseValid()) {
            return 10;
        }
        return -1;
    }

    public Map<String, Object> getAll() {
        HashMap<String, Object> flattenedMdc = new HashMap<String, Object>();
        List<String> scopeIds = this.getAllScopeIds();
        for (String scopeId : scopeIds) {
            Map<String, Object> mdcForScope = this.getMdcForScope(scopeId);
            flattenedMdc.putAll(mdcForScope);
        }
        flattenedMdc.putAll(scopeIgnorantMdc.get());
        return Collections.unmodifiableMap(flattenedMdc);
    }

    private List<String> getAllScopeIds() {
        ArrayList<String> scopeIds = new ArrayList<String>();
        Scope scope = Scope.getCurrentScope();
        scopeIds.add(scope.getScopeId());
        for (Scope parent = scope.getParent(); parent != null; parent = parent.getParent()) {
            scopeIds.add(0, parent.getScopeId());
        }
        return scopeIds;
    }
}

