/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports;

import com.datical.liquibase.ext.config.ReportConfiguration;
import com.datical.liquibase.ext.reports.FileSystemReportWriter;
import com.datical.liquibase.ext.reports.ReportType;
import com.datical.liquibase.ext.reports.ReportUtils;
import com.datical.liquibase.ext.reports.ReportWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import liquibase.Scope;
import liquibase.repackaged.com.github.mustachejava.Mustache;
import liquibase.repackaged.com.github.mustachejava.SafeMustacheFactory;
import liquibase.util.StreamUtil;
import lombok.Generated;

public abstract class AbstractReport {
    public static final String REPORT_NOT_CREATED_MESSAGE = "For users with appropriate permissions and access, operation reports are available by setting 'LIQUIBASE_REPORT_PATH' to a dir with read/write capability. Suppress this message and disable report generation by setting the 'LIQUIBASE_REPORT_ENABLED' to false. Learn more at https://docs.liquibase.com/observability";
    public static final String REPORT_WRITER_SCOPE_KEY = "reportWriter";
    private final String name;
    private final String path;

    protected AbstractReport(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public void generateReport() {
        try {
            ReportWriter reportWriter = (ReportWriter)Scope.getCurrentScope().get(REPORT_WRITER_SCOPE_KEY, (Object)new FileSystemReportWriter());
            reportWriter.write(this.getPath(), this.getName(), this.getReportString(), this.getReportType());
            if (Boolean.TRUE.equals(ReportConfiguration.OPEN.getCurrentValue())) {
                ReportUtils.openInBrowser(FileSystemReportWriter.getPathWithSuffix(this.getPath(), this.getName()));
            }
        }
        catch (Exception reportGenerationException) {
            if (Boolean.TRUE.equals(ReportConfiguration.QUIET.getCurrentValue())) {
                String message = "Could not generate report! Check your logs for more details.";
                Scope.getCurrentScope().getLog(this.getClass()).info(message, (Throwable)reportGenerationException);
                Scope.getCurrentScope().getUI().sendMessage(String.format("INFO: %s", message));
            }
            Scope.getCurrentScope().getLog(this.getClass()).info(REPORT_NOT_CREATED_MESSAGE, (Throwable)reportGenerationException);
            Scope.getCurrentScope().getUI().sendMessage(String.format("INFO: %s", REPORT_NOT_CREATED_MESSAGE));
        }
    }

    public String getReportString() throws IOException {
        HashSet<String> allowedTemplates = new HashSet<String>();
        allowedTemplates.add(this.getTemplateName());
        SafeMustacheFactory mf = new SafeMustacheFactory(allowedTemplates, this.getTemplateResourceRoot());
        Mustache mustache = mf.compile(this.getTemplateName());
        StringWriter stringWriter = new StringWriter();
        mustache.execute((Writer)stringWriter, this.getReportParameters()).flush();
        if (stringWriter.toString() != null) {
            return this.replacePlaceholders(stringWriter.toString());
        }
        return null;
    }

    private String replacePlaceholders(String html) throws IOException {
        String sharedDriftUpdateStylingPlaceholder = "/* custom styling placeholder 6dd1d8be-a0e8-4074-977f-cea8a2497156 */";
        String sharedDriftUpdateScriptPlaceholder = "// custom script placeholder 55394330-f5e0-40b3-a840-8862c7e1683b";
        String sharedHeaderImage = "<!-- header image placeholder 9288b8b9-dc31-4cdc-a806-330e1a147637 -->";
        if (html.contains("/* custom styling placeholder 6dd1d8be-a0e8-4074-977f-cea8a2497156 */")) {
            html = this.replacePlaceholder(html, "/* custom styling placeholder 6dd1d8be-a0e8-4074-977f-cea8a2497156 */", "liquibase/html/shared-drift-update-styling.css");
        }
        if (html.contains("// custom script placeholder 55394330-f5e0-40b3-a840-8862c7e1683b")) {
            html = this.replacePlaceholder(html, "// custom script placeholder 55394330-f5e0-40b3-a840-8862c7e1683b", "liquibase/html/shared-drift-update-script.js");
        }
        if (html.contains("<!-- header image placeholder 9288b8b9-dc31-4cdc-a806-330e1a147637 -->")) {
            html = this.replacePlaceholder(html, "<!-- header image placeholder 9288b8b9-dc31-4cdc-a806-330e1a147637 -->", "liquibase/html/liquibase-header-img-snippet.html");
        }
        return html;
    }

    private String replacePlaceholder(String html, String placeholderText, String replacementFilepath) throws IOException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        InputStream footerStream = classloader.getResourceAsStream(replacementFilepath);
        html = html.replace(placeholderText, StreamUtil.readStreamAsString((InputStream)footerStream, (String)StandardCharsets.UTF_8.toString()));
        return html;
    }

    protected abstract Object getReportParameters();

    protected abstract String getTemplateName();

    protected abstract String getTemplateResourceRoot();

    public abstract String getReportTypeName();

    public abstract ReportType getReportType();

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPath() {
        return this.path;
    }
}

