/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage;

import com.datical.liquibase.ext.storedlogic.AbstractStoredDatabaseLogicSnapshotGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackageBody;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.DatabaseException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;

public class PackageBodySnapshotGenerator
extends AbstractStoredDatabaseLogicSnapshotGenerator {
    public PackageBodySnapshotGenerator() {
        super(DatabasePackageBody.class, new Class[]{Schema.class});
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        try {
            if (database instanceof DB2Database && database.getDatabaseMajorVersion() == 9) {
                return -1;
            }
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        if (database instanceof OracleDatabase || database instanceof DB2Database || database instanceof EnterpriseDBDatabase) {
            return super.getPriority(objectType, database);
        }
        return -1;
    }

    @Override
    protected String getObjectType(Database database) {
        return "PACKAGE BODY";
    }

    protected StoredDatabaseLogic<DatabasePackageBody> createReturnObject() {
        return new DatabasePackageBody();
    }

    @Override
    protected String getSnapshotObjectSql(StoredDatabaseLogic<?> example, Database database) throws DatabaseException {
        if (database instanceof DB2Database) {
            return "select NAME AS OBJECT_NAME, NULL AS CREATED, NULL AS LAST_MODIFIED, 'VALID' as STATUS, TEXT AS OBJECT_BODY from ALL_SOURCE where type='" + this.getObjectType(database) + "' and name='" + database.correctObjectName(example.getName(), StoredDatabaseLogic.class) + "' and schema='" + database.correctObjectName(example.getSchema().getCatalogName(), Catalog.class) + "'";
        }
        return super.getSnapshotObjectSql(example, database);
    }

    @Override
    protected String getAddToSql(Schema schema, Database database) throws DatabaseException {
        if (database instanceof DB2Database) {
            return "SELECT NAME AS OBJECT_NAME FROM ALL_SOURCE WHERE TYPE='" + this.getObjectType(database) + "' AND SCHEMA='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "'";
        }
        return super.getAddToSql(schema, database);
    }
}

